/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_3218;

public class ItemInPipe {
    public static final short PIPE_LENGTH = 2048;
    public static final short HALFWAY = 1024;
    public static final short DEFAULT_SPEED = 64;
    public static final short DEFAULT_ACCELERATION = 1;
    public static final short SPEED_LIMIT = 1024;
    public static final short DESPAWN_AGE = 24000;
    public static final Codec<ItemInPipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1799.field_24671.fieldOf("item").orElse((Object)class_1799.field_8037).forGetter(ItemInPipe::getStack), (App)Codec.SHORT.fieldOf("speed").orElse((Object)64).forGetter(ItemInPipe::getSpeed), (App)Codec.SHORT.fieldOf("progress").orElse((Object)0).forGetter(ItemInPipe::getProgress), (App)Codec.BYTE.fieldOf("from_direction").orElse((Object)0).forGetter(item -> (byte)item.getFromDirection().method_10146()), (App)Codec.BYTE.fieldOf("target_direction").orElse((Object)0).forGetter(item -> (byte)item.getTargetDirection().method_10146()), (App)Codec.BOOL.fieldOf("ejecting").orElse((Object)true).forGetter(ItemInPipe::isEjecting), (App)Codec.SHORT.fieldOf("age").orElse((Object)0).forGetter(ItemInPipe::getAge)).apply((Applicative)instance, ItemInPipe::new));
    private class_1799 stack;
    private short speed;
    private short progress;
    private class_2350 fromDirection;
    private class_2350 targetDirection;
    private boolean ejecting;
    private short age;

    public ItemInPipe(class_1799 stack, short speed, short progress, class_2350 fromDirection, class_2350 targetDirection, boolean ejecting, short age) {
        this.stack = stack;
        this.speed = (short)Math.min(speed, 1024);
        this.progress = progress;
        this.fromDirection = fromDirection;
        this.targetDirection = targetDirection;
        this.ejecting = ejecting;
        this.age = age;
    }

    public ItemInPipe(class_1799 stack, class_2350 fromDirection, class_2350 toDirection) {
        this(stack, fromDirection, toDirection, true);
    }

    public ItemInPipe(class_1799 stack, class_2350 fromDirection, class_2350 toDirection, boolean ejecting) {
        this(stack, 64, 0, fromDirection, toDirection, ejecting, 0);
    }

    public ItemInPipe(class_1799 stack, short speed, short progress, byte fromDirection, byte targetDirection, boolean ejecting, short age) {
        this(stack, speed, progress, class_2350.method_10143((int)fromDirection), class_2350.method_10143((int)targetDirection), ejecting, age);
    }

    public ItemInPipe copyWithCount(int count) {
        return new ItemInPipe(this.getStack().method_46651(count), this.speed, this.progress, this.fromDirection, this.targetDirection, this.ejecting, this.age);
    }

    public void move(short targetSpeed, short acceleration) {
        if (this.speed < targetSpeed) {
            this.speed = (short)Math.min(this.speed + acceleration, Math.min(targetSpeed, 1024));
        } else if (this.speed > targetSpeed) {
            this.speed = (short)Math.max(this.speed - acceleration, Math.max(targetSpeed, 1));
        }
        this.progress = (short)(this.progress + this.speed);
        this.age = (short)(this.age + 1);
    }

    public void drop(class_3218 level, class_2338 pos) {
        if (!this.stack.method_7960()) {
            class_243 offset = this.getRenderPosition(0.0f);
            class_1542 droppedItem = new class_1542((class_1937)level, (double)pos.method_10263() + offset.field_1352, (double)pos.method_10264() + offset.field_1351, (double)pos.method_10260() + offset.field_1350, this.stack);
            droppedItem.method_6988();
            level.method_8649((class_1297)droppedItem);
        }
    }

    public class_243 getRenderPosition(float partialTicks) {
        class_2350 d;
        float p = (float)this.progress / 2048.0f + partialTicks * (float)this.speed / 2048.0f;
        float q = 1.0f - p;
        boolean h = p < 0.5f;
        class_2350 class_23502 = d = h ? this.fromDirection : this.targetDirection;
        return new class_243(d == class_2350.field_11039 ? (double)(h ? p : q) : (double)(d == class_2350.field_11034 ? (h ? q : p) : 0.5f), d == class_2350.field_11033 ? (double)(h ? p : q) : (double)(d == class_2350.field_11036 ? (h ? q : p) : 0.5f), d == class_2350.field_11043 ? (double)(h ? p : q) : (double)(d == class_2350.field_11035 ? (h ? q : p) : 0.5f));
    }

    public class_1799 getStack() {
        return this.stack;
    }

    public void setStack(class_1799 stack) {
        this.stack = stack;
    }

    public short getProgress() {
        return this.progress;
    }

    public void resetProgress(class_2350 direction) {
        this.progress = (short)(this.progress - 2048);
        this.fromDirection = direction;
        this.targetDirection = direction;
    }

    public boolean isEjecting() {
        return this.ejecting;
    }

    public void setEjecting(boolean ejecting) {
        this.ejecting = ejecting;
    }

    public class_2350 getFromDirection() {
        return this.fromDirection;
    }

    public class_2350 getTargetDirection() {
        return this.targetDirection;
    }

    public void setTargetDirection(class_2350 direction) {
        this.targetDirection = direction;
    }

    public short getSpeed() {
        return this.speed;
    }

    public short getAge() {
        return this.age;
    }
}

