/*
 * Decompiled with CFR 0.152.
 */
package pro.mikey.justhammers.recipe;

import com.mojang.datafixers.util.Pair;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_9334;
import net.minecraft.class_9694;
import net.minecraft.class_9890;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.mikey.justhammers.HammerItem;
import pro.mikey.justhammers.config.SimpleJsonConfig;
import pro.mikey.justhammers.recipe.HammerRecipes;

public class RepairRecipe
extends class_1852 {
    public RepairRecipe(class_7710 craftingBookCategory) {
        super(craftingBookCategory);
    }

    @NotNull
    public class_2371<class_1799> method_17704(class_9694 recipeInput) {
        class_2371 remainingItems = class_2371.method_10213((int)recipeInput.method_59983(), (Object)class_1799.field_8037);
        Pair<class_1799, class_1799> repairTargets = this.getRepairTargets(recipeInput);
        if (repairTargets == null) {
            return remainingItems;
        }
        class_1799 hammer = (class_1799)repairTargets.getFirst();
        class_1799 repairItem = (class_1799)repairTargets.getSecond();
        int currentDamage = hammer.method_7919();
        boolean isNetheriteHammer = RepairRecipe.isRepairItem(hammer, new class_1799((class_1935)class_1802.field_22020));
        double repairPercentage = isNetheriteHammer ? SimpleJsonConfig.INSTANCE.durabilityRepairPercentageNetherite.get().getAsDouble() : SimpleJsonConfig.INSTANCE.durabilityRepairPercentage.get().getAsDouble();
        double repairAmount = Math.floor((double)hammer.method_7936() / 100.0 * repairPercentage);
        int neededRepairItems = Math.max(1, (int)Math.floor((double)currentDamage / repairAmount));
        neededRepairItems = Math.min(neededRepairItems, repairItem.method_7947());
        repairItem.method_7934(neededRepairItems - 1);
        return remainingItems;
    }

    public boolean matches(class_9694 recipeInput, class_1937 level) {
        return this.getRepairTargets(recipeInput) != null;
    }

    @NotNull
    public class_1799 assemble(class_9694 recipeInput, class_7225.class_7874 provider) {
        Pair<class_1799, class_1799> repairTargets = this.getRepairTargets(recipeInput);
        if (repairTargets == null) {
            return class_1799.field_8037;
        }
        class_1799 hammer = (class_1799)repairTargets.getFirst();
        class_1799 repairItem = (class_1799)repairTargets.getSecond();
        class_1799 repairedHammer = hammer.method_7972();
        boolean isNetheriteHammer = RepairRecipe.isRepairItem(hammer, new class_1799((class_1935)class_1802.field_22020));
        double percentage = isNetheriteHammer ? SimpleJsonConfig.INSTANCE.durabilityRepairPercentageNetherite.get().getAsDouble() : SimpleJsonConfig.INSTANCE.durabilityRepairPercentage.get().getAsDouble();
        double repairAmount = Math.floor((double)hammer.method_7936() / 100.0 * percentage);
        int currentDamage = hammer.method_7919();
        int neededRepairItems = Math.max(1, (int)Math.floor((double)currentDamage / repairAmount));
        int availableRepairItems = repairItem.method_7947();
        neededRepairItems = Math.min(neededRepairItems, availableRepairItems);
        double repairAmountTotal = (double)neededRepairItems * repairAmount;
        double newDamage = Math.max(0.0, (double)currentDamage - repairAmountTotal);
        repairedHammer.method_7974((int)newDamage);
        return repairedHammer;
    }

    @NotNull
    public class_1865<RepairRecipe> method_8119() {
        return HammerRecipes.REPAIR_RECIPE_SERIALIZER.get();
    }

    @Nullable
    private Pair<class_1799, class_1799> getRepairTargets(class_9694 recipeInput) {
        if (recipeInput.method_59990() != 2) {
            return null;
        }
        class_1799 hammer = null;
        for (int i = 0; i < recipeInput.method_59983(); ++i) {
            class_1799 stack = recipeInput.method_59984(i);
            class_1792 item = stack.method_7909();
            if (!(item instanceof HammerItem)) continue;
            hammer = stack;
        }
        if (hammer == null) {
            return null;
        }
        if (hammer.method_7919() == 0) {
            return null;
        }
        class_9890 repairable = (class_9890)hammer.method_58694(class_9334.field_53696);
        if (repairable == null) {
            return null;
        }
        class_1799 availableRepairItem = null;
        boolean tooManyItems = false;
        for (int i = 0; i < recipeInput.method_59983(); ++i) {
            class_1799 stack = recipeInput.method_59984(i);
            class_1792 item = stack.method_7909();
            if (item instanceof HammerItem || !repairable.method_61713(stack)) continue;
            if (availableRepairItem != null) {
                tooManyItems = true;
                break;
            }
            availableRepairItem = stack;
        }
        if (availableRepairItem == null || tooManyItems) {
            return null;
        }
        return Pair.of((Object)hammer, availableRepairItem);
    }

    private static boolean isRepairItem(class_1799 stack, class_1799 testStack) {
        class_9890 repairable = (class_9890)stack.method_58694(class_9334.field_53696);
        if (repairable == null) {
            return false;
        }
        return repairable.method_61713(testStack);
    }
}

