/*
 * Decompiled with CFR 0.152.
 */
package com.vladmarica.betterpingdisplay;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import com.vladmarica.betterpingdisplay.BetterPingDisplayMod;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;

public class Config {
    private static final int DEFAULT_PING_TEXT_COLOR = -6250336;
    private static final String DEFAULT_PING_TEXT_FORMAT = "%dms";
    private final boolean autoColorPingText;
    private final boolean renderPingBars;
    private int textColor = -6250336;
    private String textFormatString = "%dms";

    public Config(ConfigData configFileFormat) {
        if (configFileFormat.pingTextColor.startsWith("#")) {
            try {
                this.textColor = Integer.parseInt(configFileFormat.pingTextColor.substring(1), 16) | 0xFF000000;
            }
            catch (NumberFormatException ex) {
                BetterPingDisplayMod.LOGGER.error("Config option 'pingTextColor' is invalid - it must be a hex color code");
            }
        } else {
            BetterPingDisplayMod.LOGGER.error("Config option 'pingTextColor' is invalid - it must be a hex color code");
        }
        if (configFileFormat.pingTextFormatString.contains("%d")) {
            this.textFormatString = configFileFormat.pingTextFormatString;
        } else {
            BetterPingDisplayMod.LOGGER.error("Config option 'pingTextFormatString' is invalid - it needs to contain %d");
        }
        this.autoColorPingText = configFileFormat.autoColorPingText;
        this.renderPingBars = configFileFormat.renderPingBars;
    }

    public Config() {
        this(new ConfigData());
    }

    public int getTextColor() {
        return this.textColor;
    }

    public String getTextFormatString() {
        return this.textFormatString;
    }

    public boolean shouldAutoColorPingText() {
        return this.autoColorPingText;
    }

    public boolean shouldRenderPingBars() {
        return this.renderPingBars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigData loadConfigFile(File configFile) throws IOException {
        try (InputStreamReader reader = null;){
            Gson gson = new Gson();
            reader = new FileReader(configFile);
            ConfigData configData = (ConfigData)gson.fromJson((Reader)reader, ConfigData.class);
            return configData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeConfigFile(File configFile, ConfigData data) throws IOException {
        try (OutputStreamWriter writer = null;){
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            writer = new FileWriter(configFile);
            writer.write(gson.toJson((Object)data));
        }
    }

    public static class ConfigData
    implements Serializable {
        @Expose
        private boolean autoColorPingText = true;
        @Expose
        private boolean renderPingBars = false;
        @Expose
        private String pingTextColor = "#A0A0A0";
        @Expose
        private String pingTextFormatString = "%dms";
    }
}

