/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.hint;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.animator.NumberAnimator;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.clothconfig2.api.scroll.ScrollingContainer;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.CloseableScissors;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.widget.hint.HintsContainerWidget;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class HintWidget
extends WidgetWithBounds {
    private static final int MAX_WIDTH = 180;
    private static final int MAX_HEIGHT = 130;
    private final HintsContainerWidget parent;
    private final Rectangle bounds = new Rectangle();
    private final Rectangle okayBounds = new Rectangle();
    private final int margin;
    private final Supplier<Point> point;
    private final String uuid;
    private final Collection<? extends class_5348> lines;
    private List<List<class_5481>> wrapped;
    private final NumberAnimator<Double> scroll = ValueAnimator.ofDouble((double)0.0);
    private int contentHeight;

    public HintWidget(HintsContainerWidget parent, int margin, Supplier<Point> point, String uuid, Collection<? extends class_5348> lines) {
        this.parent = parent;
        this.margin = margin;
        this.point = point;
        this.uuid = uuid;
        this.lines = lines;
        this.recalculateBounds();
    }

    void recalculateBounds() {
        int screenWidth = this.minecraft.method_22683().method_4486();
        int screenHeight = this.minecraft.method_22683().method_4507();
        int width = class_3532.method_15340((int)CollectionUtils.mapAndMax(this.lines, l -> CollectionUtils.max(this.font.method_1728(l, 172), Comparator.comparingLong(value -> this.font.method_30880(value) + 8)).map(value -> this.font.method_30880(value) + 8).orElse(0), Comparator.naturalOrder()).orElse(0), (int)60, (int)180);
        Point point = this.point.get();
        int spaceLeft = Math.max(point.x - 4, 0);
        int spaceRight = Math.max(screenWidth - point.x - 4, 0);
        this.bounds.width = Math.min(width, Math.max(spaceLeft, spaceRight));
        this.bounds.x = spaceRight >= spaceLeft ? point.x + this.margin : point.x - this.margin - this.bounds.width;
        this.wrapped = CollectionUtils.map(this.lines, l -> this.font.method_1728(l, this.bounds.width - 8));
        int height = 17;
        for (List<class_5481> formattedCharSequences : this.wrapped) {
            height += formattedCharSequences.size() * 9;
            height += 2;
        }
        this.contentHeight = height - 9 - 2;
        this.bounds.height = Math.min(height, 130);
        this.bounds.y = class_3532.method_15340((int)(point.y + this.margin - this.bounds.height), (int)4, (int)(screenHeight - this.bounds.height - 4));
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        int color1;
        this.scroll.setTarget(ScrollingContainer.handleBounceBack((double)((Double)this.scroll.target()), (double)(this.contentHeight - (this.bounds.height - 8 - 9) - 9), (float)delta, (double)0.08));
        this.scroll.update((double)delta);
        int background = -267386864;
        int color2 = color1 = 0x505000FF;
        int x = this.bounds.x;
        int y = this.bounds.y;
        int width = this.bounds.width;
        int height = this.bounds.height;
        graphics.method_25296(x, y - 1, x + width, y, background, background);
        graphics.method_25296(x, y + height, x + width, y + height + 1, background, background);
        graphics.method_25296(x, y, x + width, y + height, background, background);
        graphics.method_25296(x - 1, y, x, y + height, background, background);
        graphics.method_25296(x + width, y, x + width + 1, y + height, background, background);
        graphics.method_25296(x, y + 1, x + 1, y + height - 1, color1, color2);
        graphics.method_25296(x + width - 1, y + 1, x + width, y + height - 1, color1, color2);
        graphics.method_25296(x, y, x + width, y + 1, color1, color1);
        graphics.method_25296(x, y + height - 1, x + width, y + height, color2, color2);
        int lineY = y + 4;
        try (CloseableScissors scissors = Widget.scissor(graphics, new Rectangle(x + 4, y + 4, width - 8, height - 8 - 9 - 2));){
            for (List<class_5481> block : this.wrapped) {
                for (class_5481 line : block) {
                    graphics.method_35720(this.font, line, x + 4, lineY - this.scroll.intValue(), -1);
                    lineY += 9;
                }
                lineY += 2;
            }
        }
        class_5250 okay = class_2561.method_43471((String)"gui.ok");
        int okayWidth = this.font.method_27525((class_5348)okay);
        int midPoint = x + 4 + (width - 4) / 2;
        this.okayBounds.setBounds(midPoint - okayWidth / 2, lineY, okayWidth, 9);
        if (this.okayBounds.contains(mouseX, mouseY)) {
            okay = okay.method_27692(class_124.field_1073);
        }
        graphics.method_27535(this.font, (class_2561)okay, this.okayBounds.x, this.okayBounds.y, -6710887);
        if (this.bounds.contains(mouseX, mouseY)) {
            ScreenOverlayImpl.getInstance().clearTooltips();
        }
    }

    public List<? extends class_364> method_25396() {
        return List.of();
    }

    public boolean method_25402(class_11909 event, boolean doubleClick) {
        if (this.okayBounds.contains(event.comp_4798(), event.comp_4799())) {
            this.parent.removeHint(this);
            Widgets.produceClickSound();
            return true;
        }
        return super.method_25402(event, doubleClick);
    }

    public boolean method_25401(double mouseX, double mouseY, double amountX, double amountY) {
        if (this.containsMouse(mouseX, mouseY) && amountY != 0.0) {
            this.scroll.setTo((Double)this.scroll.target() + ClothConfigInitializer.getScrollStep() * amountY * ((double)this.getBounds().getWidth() / -50.0), ClothConfigInitializer.getScrollDuration());
            return true;
        }
        return super.method_25401(mouseX, mouseY, amountX, amountY);
    }
}

