/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.favorites.history;

import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.api.LazyResettable;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.math.Dimension;
import me.shedaniel.math.FloatingRectangle;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.widgets.Button;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.util.MatrixUtils;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.impl.client.ClientHelperImpl;
import me.shedaniel.rei.impl.client.gui.widget.AutoCraftingEvaluator;
import me.shedaniel.rei.impl.client.gui.widget.favorites.history.DisplayHistoryWidget;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.joml.Vector3f;

public class DisplayEntry
extends WidgetWithBounds {
    private final LazyResettable<List<Widget>> widgets = new LazyResettable(this::setupWidgets);
    private final DisplayHistoryWidget parent;
    private final Display display;
    private final Dimension size = new Dimension(1, 1);
    private final Supplier<AutoCraftingEvaluator.AutoCraftingResult> autoCraftingResult = Suppliers.memoizeWithExpiration(this::evaluateAutoCrafting, (long)1000L, (TimeUnit)TimeUnit.MILLISECONDS);
    private boolean hasInitialBounds;
    private final ValueAnimator<FloatingRectangle> bounds = ValueAnimator.ofFloatingRectangle();
    private final Button plusButton;
    private double xOffset = 0.0;
    private boolean reachedStable = false;
    private UUID uuid = UUID.randomUUID();

    public DisplayEntry(DisplayHistoryWidget parent, Display display, @Nullable Rectangle initialBounds) {
        this.display = display;
        this.parent = parent;
        boolean bl = this.hasInitialBounds = initialBounds != null;
        if (this.hasInitialBounds) {
            this.bounds.setAs((Object)initialBounds.getFloatingBounds());
            this.plusButton = Widgets.createButton(new Rectangle(initialBounds.getMaxX() - 16, initialBounds.getMaxY() - 16, 10, 10), (class_2561)class_2561.method_43470((String)"+"));
        } else {
            this.plusButton = Widgets.createButton(new Rectangle(-1000, -1000, 10, 10), (class_2561)class_2561.method_43470((String)"+"));
        }
    }

    private AutoCraftingEvaluator.AutoCraftingResult evaluateAutoCrafting() {
        if (this.display == null) {
            return new AutoCraftingEvaluator.AutoCraftingResult();
        }
        return AutoCraftingEvaluator.evaluateAutoCrafting(false, false, this.display, this.display::provideInternalDisplayIds);
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public void markBoundsDirty() {
        this.widgets.reset();
    }

    private List<Widget> setupWidgets() {
        Rectangle parentBounds = this.parent.getBounds();
        CategoryRegistry.CategoryConfiguration<Display> configuration = CategoryRegistry.getInstance().get(this.display.getCategoryIdentifier());
        DisplayCategory<?> category = configuration.getCategory();
        Rectangle displayBounds = new Rectangle(0, 0, category.getDisplayWidth(this.display), category.getDisplayHeight());
        List<Widget> widgets = this.setupDisplay(configuration, displayBounds);
        float scale = 1.0f;
        if ((float)parentBounds.width * scale < (float)displayBounds.width) {
            scale = Math.min(scale, (float)parentBounds.width * scale / (float)displayBounds.width);
        }
        if ((float)parentBounds.height * scale < (float)displayBounds.height) {
            scale = Math.min(scale, (float)parentBounds.height * scale / (float)displayBounds.height);
        }
        float x = (float)parentBounds.getCenterX() - (float)(displayBounds.width / 2) * scale;
        float y = (float)parentBounds.getCenterY() - (float)(displayBounds.height / 2) * scale;
        FloatingRectangle newBounds = new Rectangle((double)x, (double)y, (double)((float)displayBounds.width * scale), (double)((float)displayBounds.height * scale)).getFloatingBounds();
        if (this.hasInitialBounds) {
            if (this.size.width == 1 && this.size.height == 1 && !ConfigObject.getInstance().isReducedMotion()) {
                this.bounds.setTo((Object)newBounds, 700L);
            } else {
                this.bounds.setAs((Object)newBounds);
            }
        } else {
            this.bounds.setAs((Object)newBounds);
            this.hasInitialBounds = true;
        }
        this.size.setSize(displayBounds.getSize());
        return widgets;
    }

    private List<Widget> setupDisplay(CategoryRegistry.CategoryConfiguration<Display> configuration, Rectangle displayBounds) {
        try {
            return configuration.getView(this.display).setupDisplay(this.display, displayBounds);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            ArrayList<Widget> w = new ArrayList<Widget>();
            w.add(Widgets.createRecipeBase(displayBounds).color(-4521984));
            w.add(Widgets.createLabel(new Point(displayBounds.getCenterX(), displayBounds.getCenterY() - 8), (class_2561)class_2561.method_43470((String)"Failed to initiate setupDisplay")));
            w.add(Widgets.createLabel(new Point(displayBounds.getCenterX(), displayBounds.getCenterY() + 1), (class_2561)class_2561.method_43470((String)"Check console for error")));
            return w;
        }
    }

    @Override
    public Rectangle getBounds() {
        return ((FloatingRectangle)this.bounds.value()).getBounds();
    }

    public Dimension getSize() {
        return this.size;
    }

    public boolean isStable() {
        this.widgets.get();
        FloatingRectangle target = (FloatingRectangle)this.bounds.target();
        FloatingRectangle value = (FloatingRectangle)this.bounds.value();
        return this.reachedStable || Math.abs(value.x - target.x) <= 0.5 && Math.abs(value.y - target.y) <= 0.5 && Math.abs(value.width - target.width) <= 0.5 && Math.abs(value.height - target.height) <= 0.5;
    }

    public void setReachedStable(boolean reachedStable) {
        this.reachedStable = reachedStable;
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        boolean stable = this.isStable();
        this.bounds.update((double)delta);
        FloatingRectangle target = (FloatingRectangle)this.bounds.target();
        FloatingRectangle bounds = (FloatingRectangle)this.bounds.value();
        if (!this.reachedStable && Math.abs(bounds.x - target.x) <= 0.5 && Math.abs(bounds.y - target.y) <= 0.5 && Math.abs(bounds.width - target.width) <= 0.5 && Math.abs(bounds.height - target.height) <= 0.5) {
            this.reachedStable = true;
        }
        if (stable && (bounds.getMaxX() + this.xOffset < (double)this.parent.getBounds().x || bounds.x + this.xOffset > (double)this.parent.getBounds().getMaxX())) {
            return;
        }
        graphics.method_51448().pushMatrix();
        graphics.method_51448().translate(this.xOffset(), this.yOffset());
        graphics.method_51448().scale(this.xScale(), this.yScale());
        for (Widget widget : (List)this.widgets.get()) {
            widget.method_25394(graphics, this.transformMouseX(mouseX), this.transformMouseY(mouseY), delta);
        }
        graphics.method_51448().popMatrix();
        graphics.method_51448().pushMatrix();
        if (stable && target.equals((Object)bounds)) {
            graphics.method_51448().translate((float)this.xOffset, 0.0f);
        }
        Vector3f mouse = new Vector3f((float)mouseX, (float)mouseY, 1.0f);
        graphics.method_51448().transform(mouse);
        AutoCraftingEvaluator.AutoCraftingResult result = this.autoCraftingResult.get();
        this.plusButton.setEnabled(result.successful);
        this.plusButton.setTint(result.tint);
        this.plusButton.getBounds().setBounds(new Rectangle(bounds.getMaxX() - 14.0, bounds.getMaxY() - 14.0, 10.0, 10.0));
        if (result.hasApplicable) {
            this.plusButton.setText((class_2561)class_2561.method_43470((String)"+"));
            this.plusButton.method_25394(graphics, Math.round(mouse.x()), Math.round(mouse.y()), delta);
            graphics.method_51448().popMatrix();
            if (this.plusButton.containsMouse(Math.round(mouse.x()), Math.round(mouse.y()))) {
                result.tooltipRenderer.accept(new Point(mouseX, mouseY), Tooltip::queue);
            }
            if (result.renderer != null) {
                graphics.method_51448().pushMatrix();
                graphics.method_51448().translate(this.xOffset(), this.yOffset());
                graphics.method_51448().scale(this.xScale(), this.yScale());
                Rectangle transformedBounds = MatrixUtils.transform(MatrixUtils.inverse((Matrix3x2f)graphics.method_51448()), this.getBounds());
                result.renderer.render(graphics, mouseX, mouseY, delta, (List)this.widgets.get(), transformedBounds, this.display);
                graphics.method_51448().popMatrix();
            }
        } else {
            graphics.method_51448().popMatrix();
        }
    }

    public boolean method_25402(class_11909 event, boolean doubleClick) {
        if (this.containsMouse(event.comp_4798() + this.xOffset, event.comp_4799())) {
            for (Widget widget : (List)this.widgets.get()) {
                if (!widget.method_25402(new class_11909(this.transformMouseX(event.comp_4798()), this.transformMouseY(event.comp_4799()), event.comp_4800()), doubleClick)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public boolean method_25406(class_11909 event) {
        if (this.containsMouse(event.comp_4798() + this.xOffset, event.comp_4799())) {
            for (Widget widget : (List)this.widgets.get()) {
                if (!widget.method_25406(new class_11909(this.transformMouseX(event.comp_4798()), this.transformMouseY(event.comp_4799()), event.comp_4800()))) continue;
                return true;
            }
            if (event.method_74245() == 0 && this.plusButton.containsMouse(event.comp_4798() + this.xOffset, event.comp_4799())) {
                AutoCraftingEvaluator.evaluateAutoCrafting(true, event.method_74239(), this.display, this.display::provideInternalDisplayIds);
                Widgets.produceClickSound();
                return true;
            }
            ClientHelperImpl.getInstance().openDisplayViewingScreen(Map.of(CategoryRegistry.getInstance().get(this.display.getCategoryIdentifier()).getCategory(), List.of(this.display)), null, List.of(), List.of());
            Widgets.produceClickSound();
            return true;
        }
        return super.method_25406(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean method_25404(class_11908 event) {
        try {
            Widget.pushMouse(new Point(this.transformMouseX(DisplayEntry.mouse().x), this.transformMouseY(DisplayEntry.mouse().y)));
            for (Widget widget : (List)this.widgets.get()) {
                if (!widget.method_25404(event)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            Widget.popMouse();
        }
        return super.method_25404(event);
    }

    private float xOffset() {
        FloatingRectangle bounds = (FloatingRectangle)this.bounds.value();
        FloatingRectangle target = (FloatingRectangle)this.bounds.target();
        float xOffset = (float)bounds.x;
        if (this.isStable() && target.equals((Object)bounds)) {
            xOffset = (float)((double)xOffset + this.xOffset);
        }
        return xOffset;
    }

    private float yOffset() {
        FloatingRectangle bounds = (FloatingRectangle)this.bounds.value();
        return (float)bounds.y;
    }

    private float xScale() {
        FloatingRectangle bounds = (FloatingRectangle)this.bounds.value();
        return (float)bounds.width / (float)this.size.width;
    }

    private float yScale() {
        FloatingRectangle bounds = (FloatingRectangle)this.bounds.value();
        return (float)bounds.height / (float)this.size.height;
    }

    protected int transformMouseX(int mouseX) {
        return Math.round(((float)mouseX - this.xOffset()) / this.xScale());
    }

    protected int transformMouseY(int mouseY) {
        return Math.round(((float)mouseY - this.yOffset()) / this.yScale());
    }

    protected double transformMouseX(double mouseX) {
        return (mouseX - (double)this.xOffset()) / (double)this.xScale();
    }

    protected double transformMouseY(double mouseY) {
        return (mouseY - (double)this.yOffset()) / (double)this.yScale();
    }

    public List<? extends class_364> method_25396() {
        return Collections.emptyList();
    }

    public void setScrolled(double xOffset) {
        this.xOffset = xOffset;
    }

    public List<Widget> getWidgets() {
        return (List)this.widgets.get();
    }

    public Display getDisplay() {
        return this.display;
    }
}

