/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.entry.filtering;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import me.shedaniel.rei.api.client.entry.filtering.FilteringResult;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.common.util.HashedEntryStackWrapper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class FilteringResultImpl
implements FilteringResult {
    public final Set<HashedEntryStackWrapper> hiddenStacks;
    public final Set<HashedEntryStackWrapper> shownStacks;

    public FilteringResultImpl(List<? extends EntryStack<?>> hiddenStacks, List<? extends EntryStack<?>> shownStacks) {
        this.hiddenStacks = Sets.newHashSetWithExpectedSize((int)hiddenStacks.size());
        this.shownStacks = Sets.newHashSetWithExpectedSize((int)shownStacks.size());
        this.hide(hiddenStacks);
        this.show(shownStacks);
    }

    @Override
    public FilteringResult hide(EntryStack<?> stack) {
        this.hiddenStacks.add(new HashedEntryStackWrapper(stack));
        return this;
    }

    @Override
    public FilteringResult hide(Collection<? extends EntryStack<?>> stacks) {
        this.hiddenStacks.addAll(CollectionUtils.map(stacks, HashedEntryStackWrapper::new));
        return this;
    }

    @Override
    public FilteringResult show(EntryStack<?> stack) {
        this.shownStacks.add(new HashedEntryStackWrapper(stack));
        return this;
    }

    @Override
    public FilteringResult show(Collection<? extends EntryStack<?>> stacks) {
        this.shownStacks.addAll(CollectionUtils.map(stacks, HashedEntryStackWrapper::new));
        return this;
    }
}

