/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.ap.api;

import com.kotori316.ap.VersionCheckerMod;
import com.kotori316.ap.api.VersionStatusHolder;
import java.net.URI;
import java.util.Optional;

public interface VersionCheckerEntrypoint {
    public URI versionJsonUrl();

    default public Optional<String> targetMinecraftVersion() {
        return Optional.empty();
    }

    default public boolean enabled() {
        return true;
    }

    default public void log(VersionStatusHolder holder) {
        VersionCheckerEntrypoint.logVersionInfo(holder);
    }

    public static void logVersionInfo(VersionStatusHolder holder) {
        switch (holder.versionStatus()) {
            case LATEST: {
                VersionCheckerMod.LOGGER.info("Using the latest version, '{}' for {}", (Object)holder.currentVersion(), (Object)holder.modId());
                break;
            }
            case AHEAD: {
                VersionCheckerMod.LOGGER.info("Using ahead version '{}' for {}", (Object)holder.currentVersion(), (Object)holder.modId());
                break;
            }
            case OUTDATED: {
                VersionCheckerMod.LOGGER.info("Using outdated version for {}. Latest: '{}', Current: '{}', Homepage: {}", (Object)holder.modId(), (Object)holder.latestVersion().getFriendlyString(), (Object)holder.currentVersion(), (Object)holder.homepage());
            }
        }
    }
}

