/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.ap;

import com.kotori316.ap.ModWithVersion;
import com.kotori316.ap.api.VersionCheckerEntrypoint;
import java.net.URI;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.metadata.ModMetadata;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class VersionCheckerMod
implements ModInitializer {
    public static final String MOD_ID = "kotori316_version_checker";
    public static final String KEY = "kotori316_version_checker";
    public static final Logger LOGGER = LogManager.getLogger((String)"ForgeLikeVersionChecker");

    public void onInitialize() {
        String loaderVersion = FabricLoader.getInstance().getModContainer("fabricloader").map(ModContainer::getMetadata).map(ModMetadata::getVersion).map(Version::getFriendlyString).orElse("none");
        String minecraftVersion = FabricLoader.getInstance().getModContainer("minecraft").map(ModContainer::getMetadata).map(ModMetadata::getVersion).map(Version::getFriendlyString).orElse("none");
        List list = FabricLoader.getInstance().getEntrypointContainers("kotori316_version_checker", VersionCheckerEntrypoint.class);
        Stream<ModWithVersion> fromEntryPoint = list.stream().filter(e -> ((VersionCheckerEntrypoint)e.getEntrypoint()).enabled()).map(e -> new ModWithVersion(e.getProvider().getMetadata().getId(), e.getProvider().getMetadata().getVersion(), ((VersionCheckerEntrypoint)e.getEntrypoint()).versionJsonUrl(), ((VersionCheckerEntrypoint)e.getEntrypoint()).targetMinecraftVersion().orElse(minecraftVersion), minecraftVersion, ((VersionCheckerEntrypoint)e.getEntrypoint())::log, loaderVersion));
        Stream fromCustom = FabricLoader.getInstance().getAllMods().stream().map(ModContainer::getMetadata).filter(m -> m.containsCustomValue("kotori316_version_checker")).flatMap(m -> {
            try {
                String uri = m.getCustomValue("kotori316_version_checker").getAsString();
                return Stream.of(new ModWithVersion(m.getId(), m.getVersion(), URI.create(uri), minecraftVersion, minecraftVersion, VersionCheckerEntrypoint::logVersionInfo, loaderVersion));
            }
            catch (RuntimeException e) {
                LOGGER.warn("Invalid configuration of {} in {}", (Object)"kotori316_version_checker", (Object)m.getId());
                return Stream.empty();
            }
        });
        CompletableFuture[] versions = (CompletableFuture[])Stream.concat(fromEntryPoint, fromCustom).map(ModWithVersion::asRunnable).map(CompletableFuture::runAsync).toArray(CompletableFuture[]::new);
        CompletableFuture.allOf(versions);
    }
}

