/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.api.season;

import com.mojang.serialization.Codec;
import java.util.Locale;
import net.minecraft.class_3542;
import sereneseasons.api.season.ISeasonColorProvider;

public enum Season {
    SPRING,
    SUMMER,
    AUTUMN,
    WINTER;


    public static enum TropicalSeason implements ISeasonColorProvider
    {
        EARLY_DRY(0xFFFFFF, 0xFFFFFF, 8431445),
        MID_DRY(10847848, 0.8f, 12027516, 0.95f, 10003787),
        LATE_DRY(9337709, 0.9f, 10521478, 0.975f, 8431445),
        EARLY_WET(7703690, 7507089, 8431445),
        MID_WET(5538692, 2398382, 7777388),
        LATE_WET(6654345, 5146771, 8431445);

        public static final TropicalSeason[] VALUES;
        private int grassOverlay;
        private float grassSaturationMultiplier;
        private int foliageOverlay;
        private float foliageSaturationMultiplier;
        private int birchColor;

        private TropicalSeason(int grassColour, float grassSaturation, int foliageColour, float foliageSaturation, int birchColor) {
            this.grassOverlay = grassColour;
            this.grassSaturationMultiplier = grassSaturation;
            this.foliageOverlay = foliageColour;
            this.foliageSaturationMultiplier = foliageSaturation;
            this.birchColor = birchColor;
        }

        private TropicalSeason(int grassColour, int foliageColour, int birchColor) {
            this(grassColour, -1.0f, foliageColour, -1.0f, birchColor);
        }

        @Override
        public int getGrassOverlay() {
            return this.grassOverlay;
        }

        @Override
        public float getGrassSaturationMultiplier() {
            return this.grassSaturationMultiplier;
        }

        @Override
        public int getFoliageOverlay() {
            return this.foliageOverlay;
        }

        @Override
        public float getFoliageSaturationMultiplier() {
            return this.foliageSaturationMultiplier;
        }

        @Override
        public int getBirchColor() {
            return this.birchColor;
        }

        static {
            VALUES = TropicalSeason.values();
        }
    }

    public static enum SubSeason implements ISeasonColorProvider,
    class_3542
    {
        EARLY_SPRING(SPRING, 0x778087, 0.85f, 7307663, 0.85f, 8821352),
        MID_SPRING(SPRING, 6783639, 5211823, 7254659),
        LATE_SPRING(SPRING, 7307663, 6259871, 7646835),
        EARLY_SUMMER(SUMMER, 0x778087, 7307663, 8039012),
        MID_SUMMER(SUMMER, 0xFFFFFF, 0xFFFFFF, 8431445),
        LATE_SUMMER(SUMMER, 0x877777, 0x9F5F5F, 10003787),
        EARLY_AUTUMN(AUTUMN, 0x8F6F6F, 0xC44040, 11641922),
        MID_AUTUMN(AUTUMN, 0x9F5F5F, 15671585, 14852657),
        LATE_AUTUMN(AUTUMN, 0xAF4F4F, 0.85f, 14364720, 0.85f, 13208117),
        EARLY_WINTER(WINTER, 0xAF4F4F, 0.6f, 14364720, 0.6f, 11629115),
        MID_WINTER(WINTER, 0xAF4F4F, 0.45f, 14364720, 0.45f, 10519117),
        LATE_WINTER(WINTER, 0x8E8181, 0.6f, 10842224, 0.6f, 9409119);

        public static final Codec<SubSeason> CODEC;
        public static final SubSeason[] VALUES;
        private Season season;
        private int grassOverlay;
        private float grassSaturationMultiplier;
        private int foliageOverlay;
        private float foliageSaturationMultiplier;
        private int birchColor;

        private SubSeason(Season season, int grassColour, float grassSaturation, int foliageColour, float foliageSaturation, int birchColor) {
            this.season = season;
            this.grassOverlay = grassColour;
            this.grassSaturationMultiplier = grassSaturation;
            this.foliageOverlay = foliageColour;
            this.foliageSaturationMultiplier = foliageSaturation;
            this.birchColor = birchColor;
        }

        private SubSeason(Season season, int grassColour, int foliageColour, int birchColor) {
            this(season, grassColour, -1.0f, foliageColour, -1.0f, birchColor);
        }

        public Season getSeason() {
            return this.season;
        }

        @Override
        public int getGrassOverlay() {
            return this.grassOverlay;
        }

        @Override
        public float getGrassSaturationMultiplier() {
            return this.grassSaturationMultiplier;
        }

        @Override
        public int getFoliageOverlay() {
            return this.foliageOverlay;
        }

        @Override
        public float getFoliageSaturationMultiplier() {
            return this.foliageSaturationMultiplier;
        }

        @Override
        public int getBirchColor() {
            return this.birchColor;
        }

        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = class_3542.method_28140(SubSeason::values);
            VALUES = SubSeason.values();
        }
    }
}

