/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.cristellib.util;

import com.mojang.datafixers.util.Pair;
import de.cristelknight.cristellib.CristelLib;
import de.cristelknight.cristellib.CristelLibExpectPlatform;
import de.cristelknight.cristellib.CristelLibRegistry;
import de.cristelknight.cristellib.ModLoadingUtil;
import de.cristelknight.cristellib.StructureConfig;
import de.cristelknight.cristellib.autoconfig.ACConfig;
import de.cristelknight.cristellib.autoconfig.ACInfoData;
import de.cristelknight.cristellib.autoconfig.ModFinder;
import de.cristelknight.cristellib.config.ConfigManager;
import de.cristelknight.cristellib.data.ReadData;
import de.cristelknight.cristellib.util.Platform;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_151;
import net.minecraft.class_2561;
import org.apache.commons.io.FileUtils;

public class Util {
    public static final class_2561 CRISTEL_LIB = class_2561.method_43470((String)"Cristel Lib").method_27692(class_124.field_1076).method_27692(class_124.field_1073);
    private static final Set<String> SKIP_MODS = Set.of("neoforge", "java", "cristellib", "modmenu", "cloth-config", "cloth-basic-math");

    public static boolean isClothConfigLoaded() {
        if (CristelLibExpectPlatform.getPlatform().equals((Object)Platform.FABRIC)) {
            return ModLoadingUtil.isModLoaded("cloth-config");
        }
        return ModLoadingUtil.isModLoaded("cloth_config");
    }

    public static Path janksonPathFromString(String path, String name) {
        return Util.pathFromString(path).resolve(name + ".json5");
    }

    public static Path pathFromString(String path) {
        return path.startsWith("<CONFIG_DIR>/") ? ConfigManager.CONFIG_DIR.resolve(path.replace("<CONFIG_DIR>/", "")) : Path.of(path, new String[0]);
    }

    public static String fileName(Path path) {
        if (path == null) {
            throw new IllegalArgumentException("Path cannot be null");
        }
        Path file = path.getFileName();
        if (file == null) {
            throw new IllegalArgumentException("Path cannot have zero elements");
        }
        return Util.cutFileType(file);
    }

    public static String cutFileType(Path path) {
        if (path == null) {
            throw new IllegalArgumentException("Path cannot be null");
        }
        String fileName = path.toString();
        int dotIndex = fileName.lastIndexOf(46);
        return dotIndex > 0 ? fileName.substring(0, dotIndex) : fileName;
    }

    public static String normalizeResourcePath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Path cannot be null");
        }
        String normalized = path.replace('\\', '/');
        if (!normalized.isEmpty() && normalized.charAt(0) == '/') {
            normalized = normalized.substring(1);
        }
        while (normalized.contains("//")) {
            normalized = normalized.replace("//", "/");
        }
        return normalized;
    }

    public static void renameFile(Path path, String newBaseName) {
        String filename = path.getFileName().toString();
        int dotIndex = filename.lastIndexOf(46);
        String ext = dotIndex == -1 ? "" : filename.substring(dotIndex);
        Path newPath = path.resolveSibling(newBaseName + ext);
        try {
            Files.move(path, newPath, new CopyOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(CristelLib.getWithPrefix("Tried to rename file at path: " + String.valueOf(path) + ", to: " + newBaseName));
        }
    }

    public static Pair<String, String> parseNamespaceAndPath(String fileName, char separator) throws IllegalArgumentException {
        int sepIndex = fileName.indexOf(separator);
        if (sepIndex < 1 || sepIndex == fileName.length() - 1) {
            throw new class_151("Invalid file name: " + fileName + ", missing or misplaced separator '" + separator + "'");
        }
        String namespace = fileName.substring(0, sepIndex);
        String path = fileName.substring(sepIndex + 1);
        return new Pair((Object)namespace, (Object)path);
    }

    public static <V> V getFirst(Collection<V> collection) {
        Iterator<V> it = collection.iterator();
        return it.hasNext() ? (V)it.next() : null;
    }

    public static <T extends Comparable<T>> List<T> sortedKeyList(Map<T, ?> map) {
        return map.keySet().stream().sorted().toList();
    }

    public static void readData(Map<String, Set<StructureConfig>> configs, CristelLibRegistry registry) {
        Util.updateOldFiles();
        HashMap<String, Set<String>> modIdAndSets = new HashMap<String, Set<String>>();
        HashMap<String, ACInfoData> autoConfigInfoData = new HashMap<String, ACInfoData>();
        for (String modID : CristelLibExpectPlatform.getModIds()) {
            if (SKIP_MODS.contains(modID)) continue;
            Set<String> structureSets = ReadData.readData(modID, autoConfigInfoData, configs);
            modIdAndSets.put(modID, structureSets);
        }
        ACInfoData.currentData = autoConfigInfoData;
        ACConfig.updateConfig();
        for (String modId : modIdAndSets.keySet()) {
            if (ModFinder.shouldSkipModForACAfter(modId, configs.keySet())) continue;
            ModFinder.addAutoConfigs(modId, (Set)modIdAndSets.get(modId), configs, registry);
        }
    }

    private static void updateOldFiles() {
        try {
            Path oldPath = ConfigManager.CONFIG_LIB.resolve("data");
            Util.updateDirectories("structure_config", oldPath);
            Util.updateDirectories("data_pack", oldPath);
            Util.updateDirectories("copy_file", oldPath);
            if (Files.exists(oldPath, new LinkOption[0])) {
                Files.move(oldPath, ConfigManager.CONFIG_LIB.resolve("~OUTDATED DIRECTORY~ data"), new CopyOption[0]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void updateDirectories(String subPath, Path oldPath) throws IOException {
        Path oldSubPath = oldPath.resolve(subPath);
        Path oldOldSubPath = oldPath.resolve(subPath + "s");
        if (Files.exists(oldSubPath, new LinkOption[0])) {
            FileUtils.copyDirectory((File)oldSubPath.toFile(), (File)ConfigManager.CONFIG_LIB.resolve(subPath).toFile());
        } else if (Files.exists(oldOldSubPath, new LinkOption[0])) {
            FileUtils.copyDirectory((File)oldOldSubPath.toFile(), (File)ConfigManager.CONFIG_LIB.resolve(subPath).toFile());
        }
    }
}

