/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.cristellib.config.client.simple.custom;

import de.cristelknight.cristellib.config.client.simple.custom.ConfigFieldFactory;
import de.cristelknight.cristellib.config.simple.custom.AlphaColorField;
import de.cristelknight.cristellib.config.simple.custom.ColorField;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;

@Environment(value=EnvType.CLIENT)
public class SimpleScreenTypes {
    private static final List<EntryPredicate> FIELD_ENTRIES = new ArrayList<EntryPredicate>();

    public static void addEntry(ConfigFieldFactory<?> factory, Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            FIELD_ENTRIES.add(new EntryPredicate(c -> c == clazz, value -> true, new ScreenFieldEntry(factory, Optional.empty())));
        }
    }

    public static void addEntry(ConfigFieldFactory<?> factory, Function<Object, ?> toOriginal, Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            FIELD_ENTRIES.add(new EntryPredicate(c -> c == clazz, value -> true, new ScreenFieldEntry(factory, Optional.of(toOriginal))));
        }
    }

    public static void addAdvancedEntry(Predicate<Class<?>> classMatcher, Predicate<Object> valueMatcher, ConfigFieldFactory<?> factory) {
        FIELD_ENTRIES.add(new EntryPredicate(Objects.requireNonNull(classMatcher), valueMatcher == null ? v -> true : valueMatcher, new ScreenFieldEntry(factory, Optional.empty())));
    }

    public static <V> void addAdvancedEntry(Predicate<Class<?>> classMatcher, Predicate<Object> valueMatcher, ConfigFieldFactory<?> factory, Function<Object, V> toOriginal) {
        FIELD_ENTRIES.add(new EntryPredicate(Objects.requireNonNull(classMatcher), valueMatcher == null ? v -> true : valueMatcher, new ScreenFieldEntry(factory, Optional.of(toOriginal))));
    }

    public static Optional<ScreenFieldEntry> getEntry(Class<?> clazz, Object value) {
        return FIELD_ENTRIES.stream().filter(e -> e.classMatcher().test(clazz) && e.valueMatcher().test(value)).map(EntryPredicate::entry).findFirst();
    }

    static {
        SimpleScreenTypes.addEntry((ConfigEntryBuilder entryBuilder, String name, Object value, Object defaultValue) -> entryBuilder.startStrField((class_2561)class_2561.method_43470((String)name), (String)value).setDefaultValue((String)defaultValue), String.class);
        SimpleScreenTypes.addEntry((ConfigEntryBuilder entryBuilder, String name, Object value, Object defaultValue) -> entryBuilder.startIntField((class_2561)class_2561.method_43470((String)name), ((Number)value).intValue()).setDefaultValue(((Number)defaultValue).intValue()), Integer.class, Integer.TYPE);
        SimpleScreenTypes.addEntry((ConfigEntryBuilder entryBuilder, String name, Object value, Object defaultValue) -> entryBuilder.startDoubleField((class_2561)class_2561.method_43470((String)name), ((Number)value).doubleValue()).setDefaultValue(((Number)defaultValue).doubleValue()), Double.class, Double.TYPE);
        SimpleScreenTypes.addEntry((ConfigEntryBuilder entryBuilder, String name, Object value, Object defaultValue) -> entryBuilder.startBooleanToggle((class_2561)class_2561.method_43470((String)name), ((Boolean)value).booleanValue()).setDefaultValue(((Boolean)defaultValue).booleanValue()), Boolean.class, Boolean.TYPE);
        SimpleScreenTypes.addEntry((ConfigEntryBuilder entryBuilder, String name, Object value, Object defaultValue) -> entryBuilder.startColorField((class_2561)class_2561.method_43470((String)name), ((ColorField)value).toInt()).setDefaultValue(((ColorField)defaultValue).toInt()), (Object intColor) -> ColorField.fromInt((Integer)intColor), ColorField.class);
        SimpleScreenTypes.addEntry((ConfigEntryBuilder entryBuilder, String name, Object value, Object defaultValue) -> entryBuilder.startAlphaColorField((class_2561)class_2561.method_43470((String)name), ((AlphaColorField)value).toInt()).setDefaultValue(((AlphaColorField)defaultValue).toInt()), (Object intColor) -> AlphaColorField.fromInt((Integer)intColor), AlphaColorField.class);
        SimpleScreenTypes.addAdvancedEntry(List.class::isAssignableFrom, value -> {
            List list;
            return value instanceof List && (list = (List)value).stream().allMatch(it -> it instanceof String);
        }, (entryBuilder, name, value, defaultValue) -> entryBuilder.startStrList((class_2561)class_2561.method_43470((String)name), (List)value).setDefaultValue((List)defaultValue));
    }

    private record EntryPredicate(Predicate<Class<?>> classMatcher, Predicate<Object> valueMatcher, ScreenFieldEntry entry) {
    }

    public record ScreenFieldEntry(ConfigFieldFactory<?> fieldFactory, Optional<Function<Object, ?>> toOriginal) {
        public boolean hasConverter() {
            return this.toOriginal.isPresent();
        }
    }
}

