/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.util.serialization;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reborncore.common.util.serialization.ItemStackSerializer;

public class SerializationUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerializationUtil.class);
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().enableComplexMapKeySerialization().registerTypeAdapter(class_1799.class, (Object)new ItemStackSerializer()).create();
    public static final Gson GSON_FLAT = new GsonBuilder().enableComplexMapKeySerialization().registerTypeAdapter(class_1799.class, (Object)new ItemStackSerializer()).create();

    public static Stream<JsonElement> stream(JsonArray array) {
        return IntStream.range(0, array.size()).mapToObj(arg_0 -> ((JsonArray)array).get(arg_0));
    }

    public static JsonArray asArray(List<JsonElement> elements) {
        JsonArray array = new JsonArray();
        elements.forEach(arg_0 -> ((JsonArray)array).add(arg_0));
        return array;
    }

    public static <T> T parseNbt(Codec<T> codec, class_2487 nbt, class_7225.class_7874 wrapperLookup, Supplier<T> fallback, String fallbackMessage) {
        class_6903 ops = wrapperLookup.method_57093((DynamicOps)class_2509.field_11560);
        DataResult result = codec.parse((DynamicOps)ops, (Object)nbt);
        if (result.isSuccess()) {
            return (T)result.getOrThrow();
        }
        LOGGER.debug("Failed to read {} from NBT: {}", (Object)fallbackMessage, result.error().get());
        return fallback.get();
    }

    public static <T> class_2487 writeNbt(Codec<T> codec, T value, class_7225.class_7874 wrapperLookup) {
        class_6903 ops = wrapperLookup.method_57093((DynamicOps)class_2509.field_11560);
        class_2487 nbtCompound = new class_2487();
        return (class_2487)codec.encode(value, (DynamicOps)ops, (Object)nbtCompound).getOrThrow();
    }
}

