/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.misc.world;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import org.jetbrains.annotations.Nullable;

public class ChunkPosMultiMap<T> {
    private final Map<class_1937, HashMap<class_1923, Set<T>>> storage = new HashMap<class_1937, HashMap<class_1923, Set<T>>>();

    public final void add(class_1937 world, class_1923 chunkPos, T t) {
        this.storage.computeIfAbsent(world, w -> new HashMap()).computeIfAbsent(chunkPos, p -> new HashSet()).add(t);
    }

    public final void remove(class_1937 world, class_1923 chunkPos, T t) {
        Map chunkPosMap = this.storage.get(world);
        Set tSet = (Set)chunkPosMap.get(chunkPos);
        if (!tSet.remove(t)) {
            throw new RuntimeException("Could not remove element at position " + String.valueOf(chunkPos) + " as it does not exist.");
        }
        if (tSet.isEmpty()) {
            chunkPosMap.remove(chunkPos);
            if (chunkPosMap.isEmpty()) {
                this.storage.remove(world);
            }
        }
    }

    @Nullable
    public final Set<T> get(class_1937 world, class_1923 chunkPos) {
        Map chunkPosSetMap = this.storage.get(world);
        if (chunkPosSetMap == null) {
            return null;
        }
        return (Set)chunkPosSetMap.get(chunkPos);
    }

    public final int size() {
        return this.storage.size();
    }
}

