/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.blockentity;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_5558;
import net.minecraft.class_7225;
import net.minecraft.class_8942;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import reborncore.RebornCore;
import reborncore.api.IListInfoProvider;
import reborncore.api.blockentity.IUpgrade;
import reborncore.api.blockentity.IUpgradeable;
import reborncore.api.blockentity.InventoryProvider;
import reborncore.api.recipe.IRecipeCrafterProvider;
import reborncore.common.blockentity.FluidConfiguration;
import reborncore.common.blockentity.MultiblockWriter;
import reborncore.common.blockentity.RedstoneConfigurable;
import reborncore.common.blockentity.RedstoneConfiguration;
import reborncore.common.blockentity.SlotConfiguration;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.fluid.FluidValue;
import reborncore.common.misc.world.ChunkEventListener;
import reborncore.common.misc.world.ChunkEventListeners;
import reborncore.common.network.NetworkManager;
import reborncore.common.network.clientbound.CustomDescriptionPayload;
import reborncore.common.recipes.IUpgradeHandler;
import reborncore.common.recipes.RecipeCrafter;
import reborncore.common.util.RebornInventory;
import reborncore.common.util.Tank;

public class MachineBaseBlockEntity
extends class_2586
implements class_5558<MachineBaseBlockEntity>,
IUpgradeable,
IUpgradeHandler,
IListInfoProvider,
class_1263,
class_1278,
RedstoneConfigurable,
ChunkEventListener {
    public RebornInventory<MachineBaseBlockEntity> upgradeInventory = new RebornInventory<MachineBaseBlockEntity>(this.getUpgradeSlotCount(), "upgrades", 1, this, (slotID, stack, face, direction, blockEntity) -> true);
    private SlotConfiguration slotConfiguration;
    public FluidConfiguration fluidConfiguration;
    private RedstoneConfiguration redstoneConfiguration = new RedstoneConfiguration();
    private final List<RedstoneConfiguration.Element> redstoneElements = RedstoneConfiguration.getValidElements(this);
    public boolean renderMultiblock = false;
    private boolean shapeValid = false;
    private boolean needsRematch = false;
    @Nullable
    private Set<class_2338> shape = null;
    private static final int syncCoolDown = 20;
    private boolean markSync = false;
    private int tickTime = 0;
    public static double SPEED_CAP = 0.99;
    double speedMultiplier = 0.0;
    double powerMultiplier = 1.0;
    boolean muffled = false;

    public MachineBaseBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public void rematch() {
        MultiblockWriter.MultiblockVerifier verifier = new MultiblockWriter.MultiblockVerifier(this.method_11016(), (class_1922)this.method_10997());
        this.writeMultiblock(verifier.rotate(this.getFacing().method_10153()));
        this.shapeValid = verifier.isValid();
        this.needsRematch = false;
    }

    public boolean isShapeValid() {
        return this.shapeValid;
    }

    public void setShapeValid(boolean shapeValid) {
        this.shapeValid = shapeValid;
    }

    public void link() {
        if (this.needsRematch) {
            this.rematch();
            this.syncWithAll();
        }
    }

    public void unlink() {
        if (this.shape != null) {
            this.unregisterListeners(this.field_11863);
            this.shape = null;
        }
    }

    public void registerMultiblockVerify() {
        MultiblockWriter.MultiblockShapeFormer writer = new MultiblockWriter.MultiblockShapeFormer(this.method_11016());
        this.writeMultiblock(writer.rotate(this.getFacing().method_10153()));
        this.shape = writer.getPos();
        this.registerListeners(this.field_11863);
        this.needsRematch = true;
    }

    public Set<class_1923> getSpannedChunks() {
        HashSet<class_1923> spannedChunks = new HashSet<class_1923>();
        assert (this.shape != null);
        for (class_2338 pos : this.shape) {
            spannedChunks.add(new class_1923(pos));
        }
        return spannedChunks;
    }

    public void registerListeners(class_1937 world) {
        for (class_1923 chunkPos : this.getSpannedChunks()) {
            ChunkEventListeners.listeners.add(world, chunkPos, this);
        }
    }

    public void unregisterListeners(class_1937 world) {
        for (class_1923 chunkPos : this.getSpannedChunks()) {
            ChunkEventListeners.listeners.remove(world, chunkPos, this);
        }
    }

    @Override
    public void onBlockUpdate(class_2338 pos) {
        if (this.shape != null && this.shape.contains(pos)) {
            this.needsRematch = true;
        }
    }

    @Override
    public void onUnloadChunk() {
        this.needsRematch = true;
    }

    @Override
    public void onLoadChunk() {
        this.needsRematch = true;
    }

    public final void method_11012() {
        super.method_11012();
        if (!this.field_11863.method_8608()) {
            this.unlink();
        }
    }

    private void syncIfNecessary() {
        if (this.markSync && this.tickTime % 20 == 0) {
            this.markSync = false;
            if (this.field_11863 == null || this.field_11863.method_8608()) {
                return;
            }
            NetworkManager.sendToTracking(new CustomDescriptionPayload(this.field_11867, this.method_38244((class_7225.class_7874)this.field_11863.method_30349())), this);
        }
    }

    public void writeMultiblock(MultiblockWriter writer) {
    }

    public boolean hasMultiblock() {
        return false;
    }

    public void syncWithAll() {
        this.markSync = true;
    }

    public void onLoad() {
        if (this.slotConfiguration == null && this.getOptionalInventory().isPresent()) {
            this.slotConfiguration = new SlotConfiguration(this.getOptionalInventory().get());
        }
        if (this.getTank() != null && this.fluidConfiguration == null) {
            this.fluidConfiguration = new FluidConfiguration();
        }
        if (this.hasMultiblock() && this.field_11863 != null && !this.field_11863.method_8608()) {
            this.registerMultiblockVerify();
        }
    }

    @Nullable
    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        class_2487 compound;
        try (class_8942.class_11340 logging = new class_8942.class_11340(this.method_71402(), RebornCore.LOGGER);){
            class_11362 view = class_11362.method_71459((class_8942)logging, (class_7225.class_7874)registryLookup);
            super.method_11007((class_11372)view);
            this.method_11007((class_11372)view);
            compound = view.method_71475();
        }
        return compound;
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, MachineBaseBlockEntity blockEntity) {
        if (this.tickTime == 0) {
            this.onLoad();
        }
        ++this.tickTime;
        RecipeCrafter crafter = null;
        if (this.getOptionalCrafter().isPresent()) {
            crafter = this.getOptionalCrafter().get();
        }
        if (this.canBeUpgraded()) {
            this.resetUpgrades();
            for (int i = 0; i < this.getUpgradeSlotCount(); ++i) {
                class_1799 stack = this.getUpgradeInventory().method_5438(i);
                if (stack.method_7960() || !(stack.method_7909() instanceof IUpgrade)) continue;
                ((IUpgrade)stack.method_7909()).process(this, this, stack);
            }
            this.afterUpgradesApplication();
        }
        if (world == null || world.method_8608()) {
            return;
        }
        this.link();
        if (crafter != null && this.isActive(RedstoneConfiguration.Element.RECIPE_PROCESSING)) {
            crafter.updateEntity();
        }
        if (this.slotConfiguration != null && this.isActive(RedstoneConfiguration.Element.ITEM_IO)) {
            this.slotConfiguration.update(this);
        }
        if (this.fluidConfiguration != null && this.isActive(RedstoneConfiguration.Element.FLUID_IO)) {
            this.fluidConfiguration.update(this);
        }
        this.syncIfNecessary();
    }

    public void resetUpgrades() {
        this.resetPowerMultiplier();
        this.resetSpeedMultiplier();
        this.resetMuffler();
    }

    protected void afterUpgradesApplication() {
    }

    public int getFacingInt() {
        class_2248 block = this.field_11863.method_8320(this.field_11867).method_26204();
        if (block instanceof BlockMachineBase) {
            return ((BlockMachineBase)block).getFacing(this.field_11863.method_8320(this.field_11867)).method_10146();
        }
        return 0;
    }

    public class_2350 getFacingEnum() {
        class_2248 block = this.field_11863.method_8320(this.field_11867).method_26204();
        if (block instanceof BlockMachineBase) {
            return ((BlockMachineBase)block).getFacing(this.field_11863.method_8320(this.field_11867));
        }
        return class_2350.field_11043;
    }

    public void setFacing(class_2350 enumFacing) {
        class_2248 block = this.field_11863.method_8320(this.field_11867).method_26204();
        if (block instanceof BlockMachineBase) {
            ((BlockMachineBase)block).setFacing(enumFacing, this.field_11863, this.field_11867);
        }
    }

    public boolean isActive() {
        class_2248 block = this.field_11863.method_8320(this.field_11867).method_26204();
        if (block instanceof BlockMachineBase) {
            return (Boolean)this.field_11863.method_8320(this.field_11867).method_11654((class_2769)BlockMachineBase.ACTIVE);
        }
        return false;
    }

    public Optional<RebornInventory<?>> getOptionalInventory() {
        MachineBaseBlockEntity machineBaseBlockEntity = this;
        if (machineBaseBlockEntity instanceof InventoryProvider) {
            InventoryProvider inventory = (InventoryProvider)((Object)machineBaseBlockEntity);
            if (inventory.getInventory() == null) {
                return Optional.empty();
            }
            return Optional.of((RebornInventory)inventory.getInventory());
        }
        return Optional.empty();
    }

    protected Optional<RecipeCrafter> getOptionalCrafter() {
        MachineBaseBlockEntity machineBaseBlockEntity = this;
        if (machineBaseBlockEntity instanceof IRecipeCrafterProvider) {
            IRecipeCrafterProvider crafterProvider = (IRecipeCrafterProvider)((Object)machineBaseBlockEntity);
            if (crafterProvider.getRecipeCrafter() == null) {
                return Optional.empty();
            }
            return Optional.of(crafterProvider.getRecipeCrafter());
        }
        return Optional.empty();
    }

    public void method_11014(class_11368 view) {
        super.method_11014(view);
        if (this.getOptionalInventory().isPresent()) {
            this.getOptionalInventory().get().read(view);
        }
        if (this.getOptionalCrafter().isPresent()) {
            this.getOptionalCrafter().get().read(view);
        }
        view.method_71420("slotConfig").ifPresentOrElse(config -> {
            this.slotConfiguration = new SlotConfiguration((class_11368)config);
        }, () -> {
            if (this.getOptionalInventory().isPresent()) {
                this.slotConfiguration = new SlotConfiguration(this.getOptionalInventory().get());
            }
        });
        view.method_71420("fluidConfig").ifPresent(config -> {
            this.fluidConfiguration = new FluidConfiguration((class_11368)config);
        });
        this.redstoneConfiguration = view.method_71426("redstoneConfig", RedstoneConfiguration.CODEC.codec()).orElseGet(RedstoneConfiguration::new);
        this.upgradeInventory.read(view, "Upgrades");
    }

    public void method_11007(class_11372 view) {
        super.method_11007(view);
        if (this.getOptionalInventory().isPresent()) {
            this.getOptionalInventory().get().write(view);
        }
        if (this.getOptionalCrafter().isPresent()) {
            this.getOptionalCrafter().get().write(view);
        }
        if (this.slotConfiguration != null) {
            this.slotConfiguration.write(view.method_71461("slotConfig"));
        }
        if (this.fluidConfiguration != null) {
            this.fluidConfiguration.write(view.method_71461("fluidConfig"));
        }
        this.upgradeInventory.write(view, "Upgrades");
        view.method_71468("redstoneConfig", RedstoneConfiguration.CODEC.codec(), (Object)this.redstoneConfiguration);
    }

    @Override
    public class_1263 getUpgradeInventory() {
        return this.upgradeInventory;
    }

    @Override
    public int getUpgradeSlotCount() {
        return 4;
    }

    public class_2350 getFacing() {
        return this.getFacingEnum();
    }

    @Override
    public void resetSpeedMultiplier() {
        this.speedMultiplier = 0.0;
    }

    @Override
    public double getSpeedMultiplier() {
        return this.speedMultiplier;
    }

    @Override
    public void addPowerMultiplier(double amount) {
        this.powerMultiplier *= 1.0 + amount;
    }

    @Override
    public void resetPowerMultiplier() {
        this.powerMultiplier = 1.0;
    }

    @Override
    public double getPowerMultiplier() {
        return this.powerMultiplier;
    }

    @Override
    public long getEuPerTick(long baseEu) {
        return (long)((double)baseEu * this.powerMultiplier);
    }

    @Override
    public void addSpeedMultiplier(double amount) {
        this.speedMultiplier = this.speedMultiplier + amount <= SPEED_CAP ? (this.speedMultiplier += amount) : SPEED_CAP;
    }

    @Override
    public void muffle() {
        this.muffled = true;
    }

    @Override
    public void resetMuffler() {
        this.muffled = false;
    }

    @Override
    public boolean isMuffled() {
        return this.muffled;
    }

    public boolean hasSlotConfig() {
        return true;
    }

    @Nullable
    public Tank getTank() {
        return null;
    }

    public boolean showTankConfig() {
        return this.getTank() != null;
    }

    public int slotTransferSpeed() {
        return 4;
    }

    public FluidValue fluidTransferAmount() {
        return FluidValue.BUCKET_QUARTER;
    }

    @Override
    public void addInfo(List<class_2561> info, boolean isReal, boolean hasData) {
        if (hasData) {
            if (this.getOptionalInventory().isPresent()) {
                info.add((class_2561)class_2561.method_43470((String)(String.valueOf(class_124.field_1065) + this.getOptionalInventory().get().getContents() + String.valueOf(class_124.field_1080) + " items")));
            }
            if (!this.upgradeInventory.method_5442()) {
                info.add((class_2561)class_2561.method_43470((String)(String.valueOf(class_124.field_1065) + this.upgradeInventory.getContents() + String.valueOf(class_124.field_1080) + " upgrades")));
            }
        }
    }

    public class_2248 getBlockType() {
        return this.field_11863.method_8320(this.field_11867).method_26204();
    }

    public int method_5439() {
        if (this.getOptionalInventory().isPresent()) {
            return this.getOptionalInventory().get().method_5439();
        }
        return 0;
    }

    public boolean method_5442() {
        if (this.getOptionalInventory().isPresent()) {
            return this.getOptionalInventory().get().method_5442();
        }
        return true;
    }

    public class_1799 method_5438(int i) {
        if (this.getOptionalInventory().isPresent()) {
            return this.getOptionalInventory().get().method_5438(i);
        }
        return class_1799.field_8037;
    }

    public class_1799 method_5434(int i, int i1) {
        if (this.getOptionalInventory().isPresent()) {
            return this.getOptionalInventory().get().method_5434(i, i1);
        }
        return class_1799.field_8037;
    }

    public class_1799 method_5441(int i) {
        if (this.getOptionalInventory().isPresent()) {
            return this.getOptionalInventory().get().method_5441(i);
        }
        return class_1799.field_8037;
    }

    public void method_5447(int i, class_1799 itemStack) {
        if (this.getOptionalInventory().isPresent()) {
            this.getOptionalInventory().get().method_5447(i, itemStack);
        }
    }

    public boolean method_5443(class_1657 playerEntity) {
        if (this.getOptionalInventory().isPresent()) {
            return this.getOptionalInventory().get().method_5443(playerEntity);
        }
        return false;
    }

    public boolean method_5437(int slot, class_1799 stack) {
        RecipeCrafter crafter;
        if (this.slotConfiguration == null) {
            return false;
        }
        SlotConfiguration.SlotConfigHolder slotConfigHolder = this.slotConfiguration.getSlotDetails(slot);
        return !slotConfigHolder.filter() || !this.getOptionalCrafter().isPresent() || (crafter = this.getOptionalCrafter().get()).isStackValidInput(stack);
    }

    public void method_5448() {
        if (this.getOptionalInventory().isPresent()) {
            this.getOptionalInventory().get().method_5448();
        }
    }

    @NotNull
    public SlotConfiguration getSlotConfiguration() {
        Validate.notNull((Object)this.slotConfiguration, (String)"slotConfiguration cannot be null", (Object[])new Object[0]);
        return this.slotConfiguration;
    }

    public int[] method_5494(class_2350 side) {
        if (this.slotConfiguration == null) {
            return new int[0];
        }
        return this.slotConfiguration.getSlotsForSide(side).stream().filter(Objects::nonNull).filter(slotConfig -> slotConfig.getSlotIO().ioConfig != SlotConfiguration.ExtractConfig.NONE).mapToInt(SlotConfiguration.SlotConfig::getSlotID).toArray();
    }

    public boolean method_5492(int index, class_1799 stack, @Nullable class_2350 direction) {
        if (direction == null || this.slotConfiguration == null) {
            return false;
        }
        SlotConfiguration.SlotConfigHolder slotConfigHolder = this.slotConfiguration.getSlotDetails(index);
        SlotConfiguration.SlotConfig slotConfig = slotConfigHolder.getSideDetail(direction);
        if (slotConfig.getSlotIO().ioConfig.isInsert()) {
            if (slotConfigHolder.filter() && this.getOptionalCrafter().isPresent()) {
                RecipeCrafter crafter = this.getOptionalCrafter().get();
                return crafter.isStackValidInput(stack);
            }
            return slotConfig.getSlotIO().getIoConfig().isInsert();
        }
        return false;
    }

    public boolean method_5493(int index, class_1799 stack, class_2350 direction) {
        if (this.slotConfiguration == null) {
            return false;
        }
        SlotConfiguration.SlotConfigHolder slotConfigHolder = this.slotConfiguration.getSlotDetails(index);
        SlotConfiguration.SlotConfig slotConfig = slotConfigHolder.getSideDetail(direction);
        return slotConfig.getSlotIO().ioConfig.isExtract();
    }

    public void onBreak(class_1937 world, class_1657 playerEntity, class_2338 blockPos, class_2680 blockState) {
    }

    public void onPlace(class_1937 worldIn, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
    }

    public RedstoneConfiguration getRedstoneConfiguration() {
        return this.redstoneConfiguration;
    }

    public void setRedstoneConfiguration(RedstoneConfiguration redstoneConfiguration) {
        this.redstoneConfiguration = redstoneConfiguration;
    }

    @Override
    public boolean isActive(RedstoneConfiguration.Element element) {
        return this.redstoneConfiguration.isActive(element, this);
    }

    public List<RedstoneConfiguration.Element> getRedstoneElements() {
        return this.redstoneElements;
    }
}

