/*
 * Decompiled with CFR 0.152.
 */
package reborncore.client.gui;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1058;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_3612;
import net.minecraft.class_437;
import net.minecraft.class_4730;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6382;
import reborncore.api.IListInfoProvider;
import reborncore.client.gui.GuiBase;
import reborncore.client.gui.GuiSprites;
import reborncore.client.gui.Theme;
import reborncore.client.gui.config.GuiTab;
import reborncore.common.fluid.FluidUtils;
import reborncore.common.fluid.FluidValue;
import reborncore.common.fluid.container.FluidInstance;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.util.StringUtils;

@Environment(value=EnvType.CLIENT)
public class GuiBuilder {
    private static final class_2561 SPACE_TEXT = class_2561.method_43470((String)" ");
    @Deprecated
    public static final class_2960 GUI_ELEMENTS = class_2960.method_60655((String)"reborncore", (String)"textures/gui/guielements.png");
    private static final boolean EXPERIMENTAL_PROGRESS_BAR = false;

    public void drawDefaultBackground(class_332 drawContext, int x, int y, int width, int height) {
        drawContext.method_52706(class_10799.field_56883, GuiSprites.BACKGROUND.method_24147(), x, y, width, height);
    }

    public void drawPlayerSlots(class_332 drawContext, class_437 gui, int posX, int posY, boolean center) {
        if (center) {
            posX -= 81;
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.drawSlot(drawContext, posX + x * 18, posY + y * 18);
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.drawSlot(drawContext, posX + x * 18, posY + 58);
        }
    }

    public void drawSlot(class_332 drawContext, int posX, int posY) {
        GuiSprites.drawSpriteStretched(drawContext, GuiSprites.SLOT, posX, posY, 18, 18);
    }

    public void drawText(class_332 drawContext, GuiBase<?> gui, class_2561 text, int x, int y, int color) {
        drawContext.method_51439(gui.method_64506(), text, x, y, color, false);
    }

    public void drawProgressBar(class_332 drawContext, GuiBase<?> gui, double progress, int x, int y) {
        drawContext.method_25290(class_10799.field_56883, GUI_ELEMENTS, x, y, 150.0f, 18.0f, 22, 15, 256, 256);
        int j = (int)progress;
        if (j > 0) {
            drawContext.method_25290(class_10799.field_56883, GUI_ELEMENTS, x, y, 150.0f, 34.0f, j + 1, 15, 256, 256);
        }
    }

    public void drawOutputSlot(class_332 drawContext, int x, int y) {
        GuiSprites.drawSpriteStretched(drawContext, GuiSprites.OUTPUT_SLOT, x, y, 26, 26);
    }

    public void drawLockButton(class_332 drawContext, GuiBase<?> gui, int x, int y, int mouseX, int mouseY, GuiBase.Layer layer, boolean locked) {
        if (gui.hideGuiElements()) {
            return;
        }
        int x2 = x;
        int y2 = y;
        if (layer == GuiBase.Layer.BACKGROUND) {
            x2 += gui.getGuiLeft();
            y2 += gui.getGuiTop();
        }
        GuiSprites.drawSpriteStretched(drawContext, locked ? GuiSprites.BUTTON_LOCKED : GuiSprites.BUTTON_UNLOCKED, x2, y2, 20, 12);
        if (gui.isPointInRect(x, y, 20, 12, mouseX, mouseY)) {
            ArrayList<class_5250> list = new ArrayList<class_5250>();
            if (locked) {
                list.add(class_2561.method_43471((String)"reborncore.gui.tooltip.unlock_items"));
            } else {
                list.add(class_2561.method_43471((String)"reborncore.gui.tooltip.lock_items"));
            }
            drawContext.method_51434(gui.method_64506(), list, mouseX, mouseY);
        }
    }

    public void drawHologramButton(class_332 drawContext, GuiBase<?> gui, int x, int y, int mouseX, int mouseY, GuiBase.Layer layer) {
        if (gui.isTabOpen()) {
            return;
        }
        boolean hasTooltip = gui.isPointInRect(x, y, 20, 12, mouseX, mouseY);
        if (layer == GuiBase.Layer.BACKGROUND) {
            x += gui.getGuiLeft();
            y += gui.getGuiTop();
        }
        if (gui.getMachine().renderMultiblock) {
            GuiSprites.drawSpriteStretched(drawContext, GuiSprites.BUTTON_HOLOGRAM_ENABLED, x, y, 20, 12);
        } else {
            GuiSprites.drawSpriteStretched(drawContext, GuiSprites.BUTTON_HOLOGRAM_DISABLED, x, y, 20, 12);
        }
        if (hasTooltip) {
            ArrayList<class_5250> list = new ArrayList<class_5250>();
            list.add(class_2561.method_43471((String)"reborncore.gui.tooltip.hologram"));
            drawContext.method_51434(gui.method_64506(), list, mouseX, mouseY);
        }
    }

    public void drawBigHeatBar(class_332 drawContext, GuiBase<?> gui, int x, int y, int value, int max, GuiBase.Layer layer) {
        if (gui.hideGuiElements()) {
            return;
        }
        if (layer == GuiBase.Layer.BACKGROUND) {
            x += gui.getGuiLeft();
            y += gui.getGuiTop();
        }
        drawContext.method_25290(class_10799.field_56883, GUI_ELEMENTS, x, y, 26.0f, 218.0f, 114, 18, 256, 256);
        if (value != 0) {
            int j = (int)((double)value / (double)max * 106.0);
            if (j < 0) {
                j = 0;
            }
            drawContext.method_25290(class_10799.field_56883, GUI_ELEMENTS, x + 4, y + 4, 26.0f, 246.0f, j, 10, 256, 256);
            class_5250 text = class_2561.method_43470((String)String.valueOf(value)).method_10852((class_2561)class_2561.method_43471((String)"reborncore.gui.heat"));
            gui.drawCentredText(drawContext, (class_2561)text, y + 5, -1, layer);
        }
    }

    public void drawBigBlueBar(class_332 drawContext, GuiBase<?> gui, int x, int y, int value, int max, int mouseX, int mouseY, String suffix, class_2561 line2, String format, GuiBase.Layer layer) {
        int j;
        if (gui.hideGuiElements()) {
            return;
        }
        if (layer == GuiBase.Layer.BACKGROUND) {
            x += gui.getGuiLeft();
            y += gui.getGuiTop();
        }
        if ((j = (int)((double)value / (double)max * 106.0)) < 0) {
            j = 0;
        }
        drawContext.method_25290(class_10799.field_56883, GUI_ELEMENTS, x + 4, y + 4, 0.0f, 236.0f, j, 10, 256, 256);
        if (!((String)suffix).equals("")) {
            suffix = " " + (String)suffix;
        }
        gui.drawCentredText(drawContext, (class_2561)class_2561.method_43470((String)format).method_27693((String)suffix), y + 5, -1, layer);
        if (gui.isPointInRect(x, y, 114, 18, mouseX, mouseY)) {
            int percentage = this.percentage(max, value);
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(class_2561.method_43470((String)String.valueOf(value)).method_27692(class_124.field_1065).method_27693("/").method_27693(String.valueOf(max)).method_27693((String)suffix));
            list.add(class_2561.method_43470((String)String.valueOf(percentage)).method_27692(StringUtils.getPercentageColour(percentage)).method_27693("%").method_10852((class_2561)class_2561.method_43471((String)"reborncore.gui.tooltip.dsu_fullness").method_27692(class_124.field_1080)));
            list.add(line2);
            if (value > max) {
                list.add(class_2561.method_43470((String)"Yo this is storing more than it should be able to").method_27692(class_124.field_1080));
                list.add(class_2561.method_43470((String)"prolly a bug").method_27692(class_124.field_1080));
                list.add(class_2561.method_43470((String)"pls report and tell how tf you did this").method_27692(class_124.field_1080));
            }
            if (layer == GuiBase.Layer.FOREGROUND) {
                mouseX -= gui.getGuiLeft();
                mouseY -= gui.getGuiTop();
            }
            drawContext.method_51434(gui.method_64506(), list, mouseX, mouseY);
        }
    }

    public void drawBigBlueBar(class_332 drawContext, GuiBase<?> gui, int x, int y, int value, int max, int mouseX, int mouseY, String suffix, GuiBase.Layer layer) {
        this.drawBigBlueBar(drawContext, gui, x, y, value, max, mouseX, mouseY, suffix, (class_2561)class_2561.method_43473(), Integer.toString(value), layer);
    }

    public void drawBigBlueBar(class_332 drawContext, GuiBase<?> gui, int x, int y, int value, int max, int mouseX, int mouseY, GuiBase.Layer layer) {
        this.drawBigBlueBar(drawContext, gui, x, y, value, max, mouseX, mouseY, "", (class_2561)class_2561.method_43473(), "", layer);
    }

    public void drawMultiblockMissingBar(class_332 drawContext, GuiBase<?> gui, GuiBase.Layer layer) {
        if (gui.hideGuiElements()) {
            return;
        }
        int x = 0;
        int y = 4;
        if (layer == GuiBase.Layer.BACKGROUND) {
            x += gui.getGuiLeft();
            y += gui.getGuiTop();
        }
        drawContext.method_25296(x, y, x + 176, y + 20, 0, -1073741824);
        drawContext.method_25296(x, y + 20, x + 176, y + 20 + 48, -1073741824, -1073741824);
        drawContext.method_25296(x, y + 68, x + 176, y + 70 + 20, -1073741824, 0);
        gui.drawCentredText(drawContext, (class_2561)class_2561.method_43471((String)"reborncore.gui.missingmultiblock"), 43, -1, layer);
    }

    public void drawUpgrades(class_332 drawContext, GuiBase<?> gui, int x, int y) {
        GuiSprites.drawSpriteStretched(drawContext, GuiSprites.UPGRADES, x, y, 24, 81);
    }

    public void drawSlotTab(class_332 drawContext, GuiBase<?> gui, int x, int y, class_1799 stack) {
        GuiSprites.drawSpriteStretched(drawContext, GuiSprites.SLOT_TAB, x, y, 24, 24);
        drawContext.method_51427(stack, x + 5, y + 4);
    }

    public void drawSlotConfigTips(class_332 drawContext, GuiBase<?> gui, int x, int y, int mouseX, int mouseY, GuiTab guiTab) {
        List<class_2561> tips = guiTab.getTips().stream().map(class_2561::method_43471).collect(Collectors.toList());
        TipsListWidget explanation = new TipsListWidget(gui, gui.getScreenWidth() - 14, 76, y, 11, tips);
        explanation.method_46421(x - 81);
        explanation.method_44382(0.0);
        explanation.method_25394(drawContext, mouseX, mouseY, 1.0f);
    }

    public void drawEnergyOutput(class_332 drawContext, GuiBase<?> gui, int x, int y, int maxOutput, GuiBase.Layer layer) {
        if (gui.hideGuiElements()) {
            return;
        }
        class_5250 text = class_2561.method_43470((String)PowerSystem.getLocalizedPowerNoSuffix(maxOutput)).method_10852(SPACE_TEXT).method_27693("E").method_27693(" ");
        int width = gui.method_64506().method_27525((class_5348)text);
        gui.drawText(drawContext, (class_2561)text, x - width - 2, y + 5, -16777216, layer);
        if (layer == GuiBase.Layer.BACKGROUND) {
            x += gui.getGuiLeft();
            y += gui.getGuiTop();
        }
        drawContext.method_25290(class_10799.field_56883, GUI_ELEMENTS, x, y, 150.0f, 91.0f, 16, 16, 256, 256);
    }

    public void drawProgressBar(class_332 drawContext, GuiBase<?> gui, int progress, int maxProgress, int x, int y, int mouseX, int mouseY, ProgressDirection direction, GuiBase.Layer layer) {
        if (gui.hideGuiElements()) {
            return;
        }
        if (layer == GuiBase.Layer.BACKGROUND) {
            x += gui.getGuiLeft();
            y += gui.getGuiTop();
        }
        GuiSprites.drawSpriteStretched(drawContext, direction.baseSprite, x, y, direction.width, direction.height);
        int j = (int)((double)progress / (double)maxProgress * 16.0);
        if (j < 0) {
            j = 0;
        }
        switch (direction.ordinal()) {
            case 0: {
                drawContext.method_25290(class_10799.field_56883, GUI_ELEMENTS, x, y, (float)direction.xActive, (float)direction.yActive, j, 10, 256, 256);
                break;
            }
            case 1: {
                drawContext.method_25290(class_10799.field_56883, GUI_ELEMENTS, x + 16 - j, y, (float)(direction.xActive + 16 - j), (float)direction.yActive, j, 10, 256, 256);
                break;
            }
            case 3: {
                drawContext.method_25290(class_10799.field_56883, GUI_ELEMENTS, x, y + 16 - j, (float)direction.xActive, (float)(direction.yActive + 16 - j), 10, j, 256, 256);
                break;
            }
            case 2: {
                drawContext.method_25290(class_10799.field_56883, GUI_ELEMENTS, x, y, (float)direction.xActive, (float)direction.yActive, 10, j, 256, 256);
            }
        }
        class_1058 sprite = GuiBase.getSprite(direction.baseSprite);
        if (gui.isPointInRect(x, y, direction.width, direction.height, mouseX, mouseY)) {
            int percentage = this.percentage(maxProgress, progress);
            ArrayList<class_5250> list = new ArrayList<class_5250>();
            list.add(class_2561.method_43470((String)String.valueOf(percentage)).method_27692(StringUtils.getPercentageColour(percentage)).method_27693("%"));
            drawContext.method_51434(gui.method_64506(), list, mouseX, mouseY);
        }
    }

    public void drawMultiEnergyBar(class_332 drawContext, GuiBase<?> gui, int x, int y, long energyStored, long maxEnergyStored, int mouseX, int mouseY, int buttonID, GuiBase.Layer layer) {
        if (gui.hideGuiElements()) {
            return;
        }
        if (layer == GuiBase.Layer.BACKGROUND) {
            x += gui.getGuiLeft();
            y += gui.getGuiTop();
        }
        GuiSprites.drawSpriteStretched(drawContext, GuiSprites.POWER_BAR_BASE, x, y, 14, 50);
        int barHeight = 48;
        int draw = (int)((double)energyStored / (double)maxEnergyStored * (double)barHeight);
        if (energyStored > maxEnergyStored) {
            draw = barHeight;
        }
        GuiSprites.drawSpriteStretched(drawContext, GuiSprites.POWER_BAR_OVERLAY, x + 1, y + 49 - draw, 12, draw, 12, 48);
        int percentage = this.percentage(maxEnergyStored, energyStored);
        if (gui.isPointInRect(x + 1, y + 1, 11, 48, mouseX, mouseY)) {
            ArrayList list = Lists.newArrayList();
            boolean hasShift = class_310.method_1551().method_74187();
            if (hasShift) {
                list.add(class_2561.method_43470((String)PowerSystem.getLocalizedPowerFullNoSuffix(energyStored)).method_27692(class_124.field_1065).method_27693("/").method_27693(PowerSystem.getLocalizedPowerFull(maxEnergyStored)));
            } else {
                list.add(class_2561.method_43470((String)PowerSystem.getLocalizedPowerNoSuffix(energyStored)).method_27692(class_124.field_1065).method_27693("/").method_27693(PowerSystem.getLocalizedPower(maxEnergyStored)));
            }
            list.add(StringUtils.getPercentageText(percentage).method_10852(SPACE_TEXT).method_10852((class_2561)class_2561.method_43471((String)"reborncore.gui.tooltip.power_charged").method_27692(class_124.field_1080)));
            if (gui.be instanceof IListInfoProvider) {
                if (hasShift) {
                    ((IListInfoProvider)gui.be).addInfo(list, true, true);
                } else {
                    list.add(class_2561.method_43473());
                    list.add(class_2561.method_43470((String)"Shift").method_27692(class_124.field_1078).method_10852(SPACE_TEXT).method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43471((String)"reborncore.gui.tooltip.power_moreinfo")));
                }
            }
            drawContext.method_51434(gui.method_64506(), (List)list, mouseX, mouseY);
        }
    }

    public void drawTank(class_332 drawContext, GuiBase<?> gui, int x, int y, int mouseX, int mouseY, FluidInstance fluid, FluidValue maxCapacity, boolean isTankEmpty, GuiBase.Layer layer) {
        if (gui.hideGuiElements()) {
            return;
        }
        if (layer == GuiBase.Layer.BACKGROUND) {
            x += gui.getGuiLeft();
            y += gui.getGuiTop();
        }
        int percentage = 0;
        FluidValue amount = FluidValue.EMPTY;
        if (!isTankEmpty) {
            amount = fluid.getAmount();
            percentage = this.percentage(maxCapacity.getRawValue(), amount.getRawValue());
        }
        GuiSprites.drawSpriteStretched(drawContext, GuiSprites.TANK_BACKGROUND, x, y, 22, 56);
        if (!isTankEmpty) {
            this.drawFluid(drawContext, gui, fluid, x + 4, y + 4, 14, 48, maxCapacity.getRawValue());
        }
        GuiSprites.drawSpriteStretched(drawContext, GuiSprites.TANK_FOREGROUND, x + 3, y + 3, 16, 50);
        if (gui.isPointInRect(x, y, 22, 56, mouseX, mouseY)) {
            ArrayList<class_5250> list = new ArrayList<class_5250>();
            if (isTankEmpty) {
                list.add(class_2561.method_43471((String)"reborncore.gui.tooltip.tank_empty").method_27692(class_124.field_1065));
            } else {
                list.add(class_2561.method_43470((String)String.format("%s / %s", amount, maxCapacity)).method_27692(class_124.field_1065).method_10852(SPACE_TEXT).method_27693(FluidUtils.getFluidName(fluid)));
            }
            list.add(StringUtils.getPercentageText(percentage).method_27692(class_124.field_1080).method_10852(SPACE_TEXT).method_10852((class_2561)class_2561.method_43471((String)"reborncore.gui.tooltip.tank_fullness")));
            drawContext.method_51434(gui.method_64506(), list, mouseX, mouseY);
        }
    }

    public void drawFluid(class_332 drawContext, GuiBase<?> gui, FluidInstance fluid, int x, int y, int width, int height, long maxCapacity) {
        if (fluid.fluid() == class_3612.field_15906) {
            return;
        }
        class_1058 sprite = FluidVariantRendering.getSprite((FluidVariant)fluid.fluidVariant());
        int color = FluidVariantRendering.getColor((FluidVariant)fluid.fluidVariant());
        int drawHeight = (int)((float)fluid.getAmount().getRawValue() / ((float)maxCapacity * 1.0f) * (float)height);
        y += height - drawHeight;
        int count = drawHeight / width;
        int remainder = drawHeight % width;
        for (int i = 0; i < count; ++i) {
            drawContext.method_52710(class_10799.field_56883, sprite, x, y, width, width, color);
            y += width;
        }
        if (remainder != 0) {
            drawContext.method_44379(x, y, x + width, y + remainder);
            drawContext.method_52710(class_10799.field_56883, sprite, x, y, width, width, color);
            drawContext.method_44380();
        }
    }

    public void drawBurnBar(class_332 drawContext, GuiBase<?> gui, int progress, int maxProgress, int x, int y, int mouseX, int mouseY, GuiBase.Layer layer) {
        if (gui.hideGuiElements()) {
            return;
        }
        if (layer == GuiBase.Layer.BACKGROUND) {
            x += gui.getGuiLeft();
            y += gui.getGuiTop();
        }
        drawContext.method_25290(class_10799.field_56883, GUI_ELEMENTS, x, y, 150.0f, 64.0f, 13, 13, 256, 256);
        int j = 13 - (int)((double)progress / (double)maxProgress * 13.0);
        if (j > 0) {
            drawContext.method_25290(class_10799.field_56883, GUI_ELEMENTS, x, y + j, 150.0f, (float)(51 + j), 13, 13 - j, 256, 256);
        }
        if (gui.isPointInRect(x, y, 12, 12, mouseX, mouseY)) {
            int percentage = this.percentage(maxProgress, progress);
            ArrayList<class_5250> list = new ArrayList<class_5250>();
            list.add(StringUtils.getPercentageText(percentage));
            drawContext.method_51434(gui.method_64506(), list, mouseX, mouseY);
        }
    }

    public void drawOutputSlotBar(class_332 drawContext, int x, int y, int count) {
        GuiSprites.drawSpriteStretched(drawContext, GuiSprites.SLOT_BAR_RIGHT, x, y, 3, 26);
        x += 3;
        for (int i = 1; i <= count; ++i) {
            GuiSprites.drawSpriteStretched(drawContext, GuiSprites.SLOT_BAR_CENTER, x, y, 20, 26);
            x += 20;
        }
        GuiSprites.drawSpriteStretched(drawContext, GuiSprites.SLOT_BAR_LEFT, x, y, 3, 26);
    }

    protected int percentage(long MaxValue, long CurrentValue) {
        if (CurrentValue == 0L) {
            return 0;
        }
        return (int)((float)CurrentValue * 100.0f / (float)MaxValue);
    }

    @Environment(value=EnvType.CLIENT)
    private static class TipsListWidget
    extends class_350<TipsListEntry> {
        private final Theme theme;

        public TipsListWidget(GuiBase<?> gui, int width, int height, int top, int entryHeight, List<class_2561> tips) {
            super(gui.getMinecraft(), width, height, top, entryHeight);
            for (class_2561 tip : tips) {
                this.method_25321(new TipsListEntry(tip));
            }
            this.theme = gui.theme;
        }

        public int method_25322() {
            return 162;
        }

        public void method_25311(class_332 drawContext, int mouseX, int mouseY, float delta) {
            drawContext.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.method_25368(), this.method_46427() + this.method_25364(), -14671840);
            super.method_25311(drawContext, mouseX, mouseY, delta);
        }

        protected void method_47399(class_6382 builder) {
        }

        @Environment(value=EnvType.CLIENT)
        private class TipsListEntry
        extends class_350.class_351<TipsListEntry> {
            private final class_2561 tip;

            public TipsListEntry(class_2561 tip) {
                this.tip = tip;
            }

            public void method_25343(class_332 drawContext, int mouseX, int mouseY, boolean hovered, float deltaTicks) {
                drawContext.method_65179(class_310.method_1551().field_1772, (class_5348)this.tip, this.method_73380(), this.method_73382(), this.method_25368(), TipsListWidget.this.theme.subtitleColor().comp_1971());
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static enum ProgressDirection {
        RIGHT(58, 150, 74, 150, 16, 10),
        LEFT(74, 160, 58, 160, 16, 10),
        DOWN(78, 170, 88, 170, 10, 16),
        UP(58, 170, 68, 170, 10, 16);

        public final class_4730 baseSprite = GuiSprites.create("progress_%s_base".formatted(this.name().toLowerCase(Locale.ROOT)));
        public final class_4730 overlaySprite = GuiSprites.create("progress_%s_overlay".formatted(this.name().toLowerCase(Locale.ROOT)));
        public final int x;
        public final int y;
        public final int xActive;
        public final int yActive;
        public final int width;
        public final int height;

        private ProgressDirection(int x, int y, int xActive, int yActive, int width, int height) {
            this.x = x;
            this.y = y;
            this.xActive = xActive;
            this.yActive = yActive;
            this.width = width;
            this.height = height;
        }
    }
}

