/*
 * Decompiled with CFR 0.152.
 */
package reborncore.client;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.minecraft.class_1074;
import net.minecraft.class_11580;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_9334;
import reborncore.RebornCore;
import reborncore.api.IListInfoProvider;
import reborncore.common.BaseBlock;
import reborncore.common.BaseBlockEntityProvider;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.powerSystem.RcEnergyItem;
import reborncore.common.util.StringUtils;

@Environment(value=EnvType.CLIENT)
public class StackToolTipHandler
implements ItemTooltipCallback {
    public void getTooltip(class_1799 itemStack, class_1792.class_9635 tooltipContext, class_1836 tooltipType, List<class_2561> tooltipLines) {
        class_1792 item = itemStack.method_7909();
        class_2248 block = class_2248.method_9503((class_1792)item);
        if (block instanceof BaseBlock) {
            BaseBlock baseBlock = (BaseBlock)block;
            ArrayList<class_2561> list = new ArrayList<class_2561>();
            baseBlock.appendTooltip(itemStack, tooltipContext, list, tooltipType);
            tooltipLines.addAll(1, list);
        }
        if (item instanceof IListInfoProvider) {
            ((IListInfoProvider)item).addInfo(tooltipLines, false, false);
        } else if (item instanceof RcEnergyItem) {
            RcEnergyItem energyItem = (RcEnergyItem)item;
            class_5250 line1 = class_2561.method_43470((String)PowerSystem.getLocalizedPowerNoSuffix(energyItem.getStoredEnergy(itemStack)));
            line1.method_27693("/");
            line1.method_27693(PowerSystem.getLocalizedPower(energyItem.getEnergyCapacity(itemStack)));
            line1.method_27692(class_124.field_1065);
            tooltipLines.add(1, (class_2561)line1);
            if (class_310.method_1551().method_74187()) {
                int percentage = this.percentage(energyItem.getStoredEnergy(itemStack), energyItem.getEnergyCapacity(itemStack));
                class_5250 line2 = StringUtils.getPercentageText(percentage);
                line2.method_27693(" ");
                line2.method_27692(class_124.field_1080);
                line2.method_27693(class_1074.method_4662((String)"reborncore.gui.tooltip.power_charged", (Object[])new Object[0]));
                tooltipLines.add(2, (class_2561)line2);
                double inputRate = energyItem.getEnergyMaxInput(itemStack);
                double outputRate = energyItem.getEnergyMaxOutput(itemStack);
                class_5250 line3 = class_2561.method_43470((String)"");
                if (inputRate != 0.0 && inputRate == outputRate) {
                    line3.method_27693(class_1074.method_4662((String)"techreborn.tooltip.transferRate", (Object[])new Object[0]));
                    line3.method_27693(" : ");
                    line3.method_27692(class_124.field_1080);
                    line3.method_27693(PowerSystem.getLocalizedPower(inputRate));
                    line3.method_27692(class_124.field_1065);
                } else if (inputRate != 0.0) {
                    line3.method_27693(class_1074.method_4662((String)"reborncore.tooltip.energy.inputRate", (Object[])new Object[0]));
                    line3.method_27693(" : ");
                    line3.method_27692(class_124.field_1080);
                    line3.method_27693(PowerSystem.getLocalizedPower(inputRate));
                    line3.method_27692(class_124.field_1065);
                } else if (outputRate != 0.0) {
                    line3.method_27693(class_1074.method_4662((String)"reborncore.tooltip.energy.outputRate", (Object[])new Object[0]));
                    line3.method_27693(" : ");
                    line3.method_27692(class_124.field_1080);
                    line3.method_27693(PowerSystem.getLocalizedPower(outputRate));
                    line3.method_27692(class_124.field_1065);
                }
                tooltipLines.add(3, (class_2561)line3);
            }
        } else {
            try {
                if (block instanceof BaseBlockEntityProvider) {
                    class_2586 blockEntity = ((class_2343)block).method_10123(class_2338.field_10980, block.method_9564());
                    boolean hasData = false;
                    class_11580 nbtComponent = (class_11580)itemStack.method_58694(class_9334.field_49611);
                    if (nbtComponent != null) {
                        nbtComponent.method_72534(blockEntity, (class_7225.class_7874)class_310.method_1551().field_1687.method_30349());
                        hasData = true;
                        tooltipLines.add((class_2561)class_2561.method_43470((String)class_1074.method_4662((String)"reborncore.tooltip.has_data", (Object[])new Object[0])).method_27692(class_124.field_1077));
                    }
                    if (blockEntity instanceof IListInfoProvider) {
                        ((IListInfoProvider)blockEntity).addInfo(tooltipLines, false, hasData);
                    }
                }
            }
            catch (NullPointerException e) {
                RebornCore.LOGGER.debug("Failed to load info for " + String.valueOf(itemStack.method_7964()));
            }
        }
    }

    private int percentage(double CurrentValue, double MaxValue) {
        if (CurrentValue == 0.0) {
            return 0;
        }
        return (int)(CurrentValue * 100.0 / MaxValue);
    }
}

