/*
 * Decompiled with CFR 0.152.
 */
package net.zynwro.afk;

import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.zynwro.afk.AfkCore;

public class AfkScreen
extends class_437 {
    public static final int TIMEOUT_MIN = 5;
    public static final int TIMEOUT_MAX = 600;
    public static final int FPS_MIN = 10;
    public static final int FPS_MAX = 260;
    public static final int FOV_MIN = 30;
    public static final int FOV_MAX = 120;
    private static final String MOD_TITLE = "AFK Station";
    private static final String MOD_SUBTITLE = "Camera & HUD";
    private static final int CONTROL_WIDTH = 150;
    private static final int CONTROL_HEIGHT = 18;
    private static final int V_GAP = 9;
    private static final int H_GAP = 14;
    private static final int FOOTER_BTN_W = 80;
    private static final int FOOTER_BTN_H = 18;
    private static final int FOOTER_GAP = 12;
    private static final int FOOTER_H = 50;
    private static final double HUD_SCALE_MIN = 0.6;
    private static final double HUD_SCALE_MAX = 2.0;
    private int contentTop;
    private int colLeftX;
    private int colRightX;
    private class_4185 toggleButton;
    private TimeoutSlider timeoutSlider;
    private FpsSlider fpsSlider;
    private FovSlider fovSlider;
    private class_4185 camPowerButton;
    private class_4185 camStyleButton;
    private class_4185 chatHideButton;
    private class_4185 hudToggleButton;
    private class_4185 hudAnchorButton;
    private HudScaleSlider hudScaleSlider;
    private HudXSlider hudXSlider;
    private HudYSlider hudYSlider;
    private class_4185 cancelBtn;
    private class_4185 resetBtn;
    private class_4185 saveBtn;
    private boolean workingEnabled;
    private int workingTimeout;
    private int workingFps;
    private int workingFov;
    private boolean workingCameraEnabled;
    private int workingCameraStyle;
    private boolean workingChatHideAfk;
    private boolean workingHudEnabled;
    private AfkCore.Anchor workingHudAnchor;
    private double workingHudScale;
    private double workingHudXPercent;
    private double workingHudYPercent;
    private int scrollY;
    private int contentHeight;

    public AfkScreen(class_2561 title) {
        super(title);
    }

    protected void method_25426() {
        int cx;
        this.workingEnabled = AfkCore.CONFIG.enabled;
        this.workingTimeout = AfkCore.CONFIG.timeoutSeconds;
        this.workingFps = AfkCore.CONFIG.afkFpsCap;
        this.workingFov = AfkCore.CONFIG.afkFov;
        this.workingCameraEnabled = AfkCore.CONFIG.cameraEnabled;
        this.workingCameraStyle = AfkCore.CONFIG.cameraStyle;
        this.workingChatHideAfk = AfkCore.CONFIG.chatHideWhileAfk;
        this.workingHudEnabled = AfkCore.CONFIG.hudEnabled;
        this.workingHudAnchor = AfkCore.CONFIG.hudAnchor;
        this.workingHudScale = AfkCore.CONFIG.hudScale;
        this.workingHudXPercent = AfkCore.CONFIG.hudXPercent;
        this.workingHudYPercent = AfkCore.CONFIG.hudYPercent;
        this.contentTop = 38;
        int totalWidth = 314;
        this.colLeftX = cx = (this.field_22789 - totalWidth) / 2;
        this.colRightX = cx + 150 + 14;
        this.toggleButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)(this.workingEnabled ? "Mod: On" : "Mod: Off")), b -> {
            this.workingEnabled = !this.workingEnabled;
            b.method_25355((class_2561)class_2561.method_43470((String)(this.workingEnabled ? "Mod: On" : "Mod: Off")));
        }).method_46434(this.colLeftX, this.contentTop, 150, 18).method_46431();
        this.timeoutSlider = new TimeoutSlider(this.colLeftX, this.contentTop + 18 + 9, 150, 18, this.workingTimeout);
        this.fpsSlider = new FpsSlider(this.colLeftX, this.timeoutSlider.method_46427() + 18 + 9, 150, 18, this.workingFps);
        this.fovSlider = new FovSlider(this.colLeftX, this.fpsSlider.method_46427() + 18 + 9, 150, 18, this.workingFov);
        this.camPowerButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)(this.workingCameraEnabled ? "Camera: On" : "Camera: Off")), b -> {
            this.workingCameraEnabled = !this.workingCameraEnabled;
            b.method_25355((class_2561)class_2561.method_43470((String)(this.workingCameraEnabled ? "Camera: On" : "Camera: Off")));
        }).method_46434(this.colLeftX, this.fovSlider.method_46427() + 18 + 9, 150, 18).method_46431();
        this.camStyleButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)AfkScreen.styleLabel(this.workingCameraStyle)), b -> {
            this.workingCameraStyle = (this.workingCameraStyle + 1) % 2;
            b.method_25355((class_2561)class_2561.method_43470((String)AfkScreen.styleLabel(this.workingCameraStyle)));
        }).method_46434(this.colLeftX, this.camPowerButton.method_46427() + 18 + 9, 150, 18).method_46431();
        this.chatHideButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)(this.workingChatHideAfk ? "Hide Chat While AFK: On" : "Hide Chat While AFK: Off")), b -> {
            this.workingChatHideAfk = !this.workingChatHideAfk;
            b.method_25355((class_2561)class_2561.method_43470((String)(this.workingChatHideAfk ? "Hide Chat While AFK: On" : "Hide Chat While AFK: Off")));
        }).method_46434(this.colLeftX, this.camStyleButton.method_46427() + 18 + 9, 150, 18).method_46431();
        this.hudToggleButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)(this.workingHudEnabled ? "HUD: On" : "HUD: Off")), b -> {
            this.workingHudEnabled = !this.workingHudEnabled;
            b.method_25355((class_2561)class_2561.method_43470((String)(this.workingHudEnabled ? "HUD: On" : "HUD: Off")));
        }).method_46434(this.colRightX, this.contentTop, 150, 18).method_46431();
        this.hudAnchorButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)("Anchor: " + this.anchorLabel(this.workingHudAnchor))), b -> {
            this.workingHudAnchor = this.nextAnchor(this.workingHudAnchor);
            b.method_25355((class_2561)class_2561.method_43470((String)("Anchor: " + this.anchorLabel(this.workingHudAnchor))));
        }).method_46434(this.colRightX, this.hudToggleButton.method_46427() + 18 + 9, 150, 18).method_46431();
        this.hudScaleSlider = new HudScaleSlider(this.colRightX, this.hudAnchorButton.method_46427() + 18 + 9, 150, 18, this.workingHudScale);
        this.hudXSlider = new HudXSlider(this.colRightX, this.hudScaleSlider.method_46427() + 18 + 9, 150, 18, this.workingHudXPercent);
        this.hudYSlider = new HudYSlider(this.colRightX, this.hudXSlider.method_46427() + 18 + 9, 150, 18, this.workingHudYPercent);
        int lastLeftY = this.chatHideButton.method_46427();
        int lastRightY = this.hudYSlider.method_46427();
        this.contentHeight = Math.max(lastLeftY, lastRightY) + 18 - this.contentTop;
        int totalFooterW = 264;
        int startX = (this.field_22789 - totalFooterW) / 2;
        int y = this.field_22790 - 50 + 16;
        this.cancelBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Close"), b -> {
            class_310.method_1551().method_1507(null);
            AfkCore.suppressActivityShort();
        }).method_46434(startX, y, 80, 18).method_46431();
        this.resetBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Reset"), b -> {
            this.workingEnabled = true;
            this.workingTimeout = 30;
            this.workingFps = 30;
            this.workingFov = 30;
            this.workingCameraEnabled = true;
            this.workingCameraStyle = 0;
            this.workingChatHideAfk = false;
            this.workingHudEnabled = true;
            this.workingHudAnchor = AfkCore.Anchor.CENTER;
            this.workingHudScale = 1.0;
            this.workingHudXPercent = 0.5;
            this.workingHudYPercent = 0.5;
            this.toggleButton.method_25355((class_2561)class_2561.method_43470((String)"Mod: On"));
            this.timeoutSlider.setValueFromSeconds(this.workingTimeout);
            this.fpsSlider.setValueFromFps(this.workingFps);
            this.fovSlider.setValueFromFov(this.workingFov);
            this.camPowerButton.method_25355((class_2561)class_2561.method_43470((String)"Camera: On"));
            this.camStyleButton.method_25355((class_2561)class_2561.method_43470((String)AfkScreen.styleLabel(this.workingCameraStyle)));
            this.chatHideButton.method_25355((class_2561)class_2561.method_43470((String)"Hide Chat While AFK: Off"));
            this.hudToggleButton.method_25355((class_2561)class_2561.method_43470((String)"HUD: On"));
            this.hudAnchorButton.method_25355((class_2561)class_2561.method_43470((String)("Anchor: " + this.anchorLabel(this.workingHudAnchor))));
            this.hudScaleSlider.resetDefault();
            this.hudXSlider.resetDefault();
            this.hudYSlider.resetDefault();
        }).method_46434(startX + 80 + 12, y, 80, 18).method_46431();
        this.saveBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Save"), b -> {
            boolean oldEnabled = AfkCore.CONFIG.enabled;
            AfkCore.CONFIG.enabled = this.workingEnabled;
            AfkCore.CONFIG.timeoutSeconds = this.workingTimeout;
            AfkCore.CONFIG.afkFpsCap = this.workingFps;
            AfkCore.CONFIG.afkFov = this.workingFov;
            AfkCore.CONFIG.cameraEnabled = this.workingCameraEnabled;
            AfkCore.CONFIG.cameraStyle = this.workingCameraStyle;
            AfkCore.CONFIG.chatHideWhileAfk = this.workingChatHideAfk;
            AfkCore.CONFIG.hudEnabled = this.workingHudEnabled;
            AfkCore.CONFIG.hudAnchor = this.workingHudAnchor;
            AfkCore.CONFIG.hudScale = this.workingHudScale;
            AfkCore.CONFIG.hudXPercent = this.workingHudXPercent;
            AfkCore.CONFIG.hudYPercent = this.workingHudYPercent;
            AfkCore.saveConfig();
            AfkCore.enforceDisableEffect();
            class_310.method_1551().method_1507(null);
            if (AfkCore.CONFIG.enabled) {
                AfkCore.suppressActivityShort();
            }
            if (class_310.method_1551().field_1724 != null && oldEnabled != this.workingEnabled) {
                class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43470((String)(this.workingEnabled ? "[AFK] Enabled" : "[AFK] Disabled")), true);
            }
        }).method_46434(startX + 184, y, 80, 18).method_46431();
        this.method_37063((class_364)this.toggleButton);
        this.method_37063((class_364)this.timeoutSlider);
        this.method_37063((class_364)this.fpsSlider);
        this.method_37063((class_364)this.fovSlider);
        this.method_37063((class_364)this.camPowerButton);
        this.method_37063((class_364)this.camStyleButton);
        this.method_37063((class_364)this.chatHideButton);
        this.method_37063((class_364)this.hudToggleButton);
        this.method_37063((class_364)this.hudAnchorButton);
        this.method_37063((class_364)this.hudScaleSlider);
        this.method_37063((class_364)this.hudXSlider);
        this.method_37063((class_364)this.hudYSlider);
        this.method_37063((class_364)this.cancelBtn);
        this.method_37063((class_364)this.resetBtn);
        this.method_37063((class_364)this.saveBtn);
        this.method_25395((class_364)this.timeoutSlider);
    }

    public void method_25394(class_332 ctx, int mouseX, int mouseY, float delta) {
        try {
            this.method_25420(ctx, mouseX, mouseY, delta);
        }
        catch (IllegalStateException ignored) {
            class_437.method_57737((class_332)ctx, (class_2960)class_437.field_49511, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)this.field_22789, (int)this.field_22790);
        }
        this.positionControls();
        int headerBottom = this.contentTop - 2;
        int footerTop = this.field_22790 - 50 + 14;
        ctx.method_44379(0, headerBottom, this.field_22789, footerTop);
        super.method_25394(ctx, mouseX, mouseY, delta);
        ctx.method_44380();
        this.cancelBtn.method_25394(ctx, mouseX, mouseY, delta);
        this.resetBtn.method_25394(ctx, mouseX, mouseY, delta);
        this.saveBtn.method_25394(ctx, mouseX, mouseY, delta);
        ctx.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)MOD_TITLE), this.field_22789 / 2, 12, -1);
        ctx.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)MOD_SUBTITLE), this.field_22789 / 2, 24, -5723992);
    }

    private void positionControls() {
        int cx;
        int totalWidth = 314;
        this.colLeftX = cx = (this.field_22789 - totalWidth) / 2;
        this.colRightX = cx + 150 + 14;
        int yBaseL = this.contentTop - this.scrollY;
        int yBaseR = this.contentTop - this.scrollY;
        this.toggleButton.method_46421(this.colLeftX);
        this.toggleButton.method_46419(yBaseL);
        this.timeoutSlider.method_46421(this.colLeftX);
        this.timeoutSlider.method_46419(yBaseL += 27);
        this.fpsSlider.method_46421(this.colLeftX);
        this.fpsSlider.method_46419(yBaseL += 27);
        this.fovSlider.method_46421(this.colLeftX);
        this.fovSlider.method_46419(yBaseL += 27);
        this.camPowerButton.method_46421(this.colLeftX);
        this.camPowerButton.method_46419(yBaseL += 27);
        this.camStyleButton.method_46421(this.colLeftX);
        this.camStyleButton.method_46419(yBaseL += 27);
        this.chatHideButton.method_46421(this.colLeftX);
        this.chatHideButton.method_46419(yBaseL += 27);
        this.hudToggleButton.method_46421(this.colRightX);
        this.hudToggleButton.method_46419(yBaseR);
        this.hudAnchorButton.method_46421(this.colRightX);
        this.hudAnchorButton.method_46419(yBaseR += 27);
        this.hudScaleSlider.method_46421(this.colRightX);
        this.hudScaleSlider.method_46419(yBaseR += 27);
        this.hudXSlider.method_46421(this.colRightX);
        this.hudXSlider.method_46419(yBaseR += 27);
        this.hudYSlider.method_46421(this.colRightX);
        this.hudYSlider.method_46419(yBaseR += 27);
    }

    public boolean method_25421() {
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int maxScroll = Math.max(0, this.contentHeight - (this.field_22790 - 50 - this.contentTop));
        this.scrollY -= (int)Math.round(verticalAmount * 12.0);
        if (this.scrollY < 0) {
            this.scrollY = 0;
        }
        if (this.scrollY > maxScroll) {
            this.scrollY = maxScroll;
        }
        return true;
    }

    private static String styleLabel(int style) {
        return style == 0 ? "Style: Cinematic" : "Style: Orbit";
    }

    private String anchorLabel(AfkCore.Anchor a) {
        return switch (a) {
            default -> throw new MatchException(null, null);
            case AfkCore.Anchor.CENTER -> "Center";
            case AfkCore.Anchor.TOP_LEFT -> "Top Left";
            case AfkCore.Anchor.TOP_RIGHT -> "Top Right";
            case AfkCore.Anchor.BOTTOM_LEFT -> "Bottom Left";
            case AfkCore.Anchor.BOTTOM_RIGHT -> "Bottom Right";
            case AfkCore.Anchor.CUSTOM -> "Custom";
        };
    }

    private AfkCore.Anchor nextAnchor(AfkCore.Anchor a) {
        AfkCore.Anchor[] order = new AfkCore.Anchor[]{AfkCore.Anchor.CENTER, AfkCore.Anchor.TOP_LEFT, AfkCore.Anchor.TOP_RIGHT, AfkCore.Anchor.BOTTOM_LEFT, AfkCore.Anchor.BOTTOM_RIGHT, AfkCore.Anchor.CUSTOM};
        int idx = 0;
        for (int i = 0; i < order.length; ++i) {
            if (order[i] != a) continue;
            idx = i;
            break;
        }
        return order[(idx + 1) % order.length];
    }

    private static double toValue(int v, int min, int max) {
        int clamped = Math.max(min, Math.min(max, v));
        return (double)(clamped - min) / (double)(max - min);
    }

    private static int toScaled(double v, int min, int max) {
        return min + (int)Math.round(v * (double)(max - min));
    }

    private static double clamp(double v, double min, double max) {
        return Math.max(min, Math.min(max, v));
    }

    private static double toValScale(double scale) {
        double s = AfkScreen.clamp(scale, 0.6, 2.0);
        return (s - 0.6) / 1.4;
    }

    private static double fromValScale(double t) {
        return 0.6 + AfkScreen.clamp(t, 0.0, 1.0) * 1.4;
    }

    private class TimeoutSlider
    extends class_357 {
        TimeoutSlider(int x, int y, int width, int height, int seconds) {
            super(x, y, width, height, (class_2561)class_2561.method_43470((String)""), AfkScreen.toValue(seconds, 5, 600));
            this.method_25346();
        }

        protected void method_25346() {
            int s = AfkScreen.toScaled(this.field_22753, 5, 600);
            this.method_25355((class_2561)class_2561.method_43470((String)("Timeout: " + s + "s")));
            AfkScreen.this.workingTimeout = s;
        }

        protected void method_25344() {
            AfkScreen.this.workingTimeout = AfkScreen.toScaled(this.field_22753, 5, 600);
        }

        void setValueFromSeconds(int s) {
            this.field_22753 = AfkScreen.toValue(s, 5, 600);
            this.method_25346();
        }
    }

    private class FpsSlider
    extends class_357 {
        FpsSlider(int x, int y, int width, int height, int fps) {
            super(x, y, width, height, (class_2561)class_2561.method_43470((String)""), AfkScreen.toValue(fps, 10, 260));
            this.method_25346();
        }

        protected void method_25346() {
            int f = AfkScreen.toScaled(this.field_22753, 10, 260);
            this.method_25355((class_2561)class_2561.method_43470((String)("AFK FPS: " + f)));
            AfkScreen.this.workingFps = f;
        }

        protected void method_25344() {
            AfkScreen.this.workingFps = AfkScreen.toScaled(this.field_22753, 10, 260);
        }

        void setValueFromFps(int f) {
            this.field_22753 = AfkScreen.toValue(f, 10, 260);
            this.method_25346();
        }
    }

    private class FovSlider
    extends class_357 {
        FovSlider(int x, int y, int width, int height, int fov) {
            super(x, y, width, height, (class_2561)class_2561.method_43470((String)""), AfkScreen.toValue(fov, 30, 120));
            this.method_25346();
        }

        protected void method_25346() {
            int f = AfkScreen.toScaled(this.field_22753, 30, 120);
            this.method_25355((class_2561)class_2561.method_43470((String)("AFK FOV: " + f)));
            AfkScreen.this.workingFov = f;
        }

        protected void method_25344() {
            AfkScreen.this.workingFov = AfkScreen.toScaled(this.field_22753, 30, 120);
        }

        void setValueFromFov(int f) {
            this.field_22753 = AfkScreen.toValue(f, 30, 120);
            this.method_25346();
        }
    }

    private class HudScaleSlider
    extends class_357 {
        HudScaleSlider(int x, int y, int width, int height, double scale) {
            super(x, y, width, height, (class_2561)class_2561.method_43470((String)""), AfkScreen.toValScale(scale));
            this.method_25346();
        }

        protected void method_25346() {
            double s = AfkScreen.fromValScale(this.field_22753);
            this.method_25355((class_2561)class_2561.method_43470((String)String.format("HUD Scale: %.2fx", s)));
            AfkScreen.this.workingHudScale = s;
        }

        protected void method_25344() {
            AfkScreen.this.workingHudScale = AfkScreen.fromValScale(this.field_22753);
        }

        void resetDefault() {
            this.field_22753 = AfkScreen.toValScale(1.0);
            this.method_25346();
        }
    }

    private class HudXSlider
    extends class_357 {
        HudXSlider(int x, int y, int width, int height, double p) {
            super(x, y, width, height, (class_2561)class_2561.method_43470((String)""), p);
            this.method_25346();
        }

        protected void method_25346() {
            AfkScreen.this.workingHudXPercent = this.field_22753;
            this.method_25355((class_2561)class_2561.method_43470((String)String.format("HUD X: %.0f%%", AfkScreen.this.workingHudXPercent * 100.0)));
        }

        protected void method_25344() {
            AfkScreen.this.workingHudXPercent = this.field_22753;
        }

        void resetDefault() {
            this.field_22753 = 0.5;
            this.method_25346();
        }
    }

    private class HudYSlider
    extends class_357 {
        HudYSlider(int x, int y, int width, int height, double p) {
            super(x, y, width, height, (class_2561)class_2561.method_43470((String)""), p);
            this.method_25346();
        }

        protected void method_25346() {
            AfkScreen.this.workingHudYPercent = this.field_22753;
            this.method_25355((class_2561)class_2561.method_43470((String)String.format("HUD Y: %.0f%%", AfkScreen.this.workingHudYPercent * 100.0)));
        }

        protected void method_25344() {
            AfkScreen.this.workingHudYPercent = this.field_22753;
        }

        void resetDefault() {
            this.field_22753 = 0.5;
            this.method_25346();
        }
    }
}

