/*
 * Decompiled with CFR 0.152.
 */
package com.vsngarcia;

import com.vsngarcia.Config;
import com.vsngarcia.level.ElevatorBlockEntityBase;
import com.vsngarcia.util.FakeUseContext;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_10225;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2383;
import net.minecraft.class_2498;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_7924;

public abstract class ElevatorBlockBase
extends class_2383
implements class_2343 {
    public static final class_2746 DIRECTIONAL = class_2746.method_11825((String)"directional");
    public static final class_2746 SHOW_ARROW = class_2746.method_11825((String)"show_arrow");
    private final class_1767 dyeColor;
    private final Supplier<class_2591<? extends ElevatorBlockEntityBase>> tileEntityType;

    public ElevatorBlockBase(class_1767 color, Supplier<class_2591<? extends ElevatorBlockEntityBase>> type, class_4970.class_2251 props) {
        super(props.method_51517(color).method_9626(class_2498.field_11543).method_9632(0.8f).method_9624().method_22488().method_26235(ElevatorBlockBase.isValidSpawn(type)).method_63500(ElevatorBlockBase.getResourceKey(class_7924.field_41254, color)));
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)field_11177, (Comparable)class_2350.field_11043)).method_11657((class_2769)DIRECTIONAL, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)SHOW_ARROW, (Comparable)Boolean.valueOf(true)));
        this.dyeColor = color;
        this.tileEntityType = type;
    }

    public ElevatorBlockBase(class_1767 color, Supplier<class_2591<? extends ElevatorBlockEntityBase>> type) {
        this(color, type, class_4970.class_2251.method_9637());
    }

    public static <T> class_5321<T> getResourceKey(class_5321<class_2378<T>> type, class_1767 color) {
        return class_5321.method_29179(type, (class_2960)ElevatorBlockBase.getResourceLocation(color));
    }

    public static class_2960 getResourceLocation(class_1767 color) {
        return class_2960.method_60655((String)"elevatorid", (String)("elevator_" + color.method_7792()));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{field_11177, DIRECTIONAL, SHOW_ARROW});
    }

    public boolean method_9616(class_2680 state, class_1750 useContext) {
        return false;
    }

    protected abstract void openMenu(class_1657 var1, ElevatorBlockEntityBase var2, class_2338 var3);

    public class_1269 method_55765(class_1799 itemStack, class_2680 state, class_1937 worldIn, class_2338 pos, class_1657 player, class_1268 handIn, class_3965 hit) {
        if (worldIn.method_8608()) {
            return class_1269.field_5812;
        }
        return this.getElevatorTile((class_1922)worldIn, pos).map(tile -> {
            class_2248 handBlock = class_2248.method_9503((class_1792)player.method_5998(handIn).method_7909());
            class_2680 stateToApply = handBlock.method_9605((class_1750)new FakeUseContext(player, handIn, hit));
            if (stateToApply != null && tile.setCamoAndUpdate(stateToApply)) {
                return class_1269.field_52422;
            }
            if (player.method_18276() && tile.getHeldState() != null) {
                tile.setCamoAndUpdate(null);
                return class_1269.field_52422;
            }
            this.openMenu(player, (ElevatorBlockEntityBase)((Object)tile), pos);
            return class_1269.field_52422;
        }).orElse((class_1269)class_1269.field_5811);
    }

    public static class_4970.class_4972<class_1299<?>> isValidSpawn(Supplier<class_2591<? extends ElevatorBlockEntityBase>> tileType) {
        return (state, world, pos, entityType) -> (Boolean)Config.GENERAL.mobSpawn.get() != false && world.method_35230(pos, (class_2591)tileType.get()).map(ElevatorBlockEntityBase::getHeldState).map(s -> s.method_26170(world, pos, entityType)).orElse(state.method_26206(world, pos, class_2350.field_11036)) != false;
    }

    public class_265 method_9549(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
        return this.getHeldState(worldIn, pos).map(s -> s.method_26194(worldIn, pos, context)).orElse(super.method_9549(state, worldIn, pos, context));
    }

    public boolean method_37403(class_2680 state, class_1922 world, class_2338 pos) {
        return this.getHeldState(world, pos).map(s -> s.method_26234(world, pos)).orElse(super.method_37403(state, world, pos));
    }

    public class_265 method_9530(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
        return this.getHeldState(worldIn, pos).map(s -> s.method_26172(worldIn, pos, context)).orElse(super.method_9530(state, worldIn, pos, context));
    }

    public float method_23349() {
        return super.method_23349();
    }

    public float method_23350() {
        return super.method_23350();
    }

    protected class_2680 method_9559(class_2680 blockState, class_4538 levelReader, class_10225 scheduledTickAccess, class_2338 currentPos, class_2350 direction, class_2338 facingPos, class_2680 facingState, class_5819 randomSource) {
        this.getElevatorTile((class_1922)levelReader, currentPos).ifPresent(t -> {
            if (t.getHeldState() == null) {
                return;
            }
            class_2680 appearance = this.getAppearance(facingState, levelReader, facingPos, direction, t.getHeldState(), currentPos);
            class_2680 updatedState = t.getHeldState().method_26191(levelReader, scheduledTickAccess, currentPos, direction, facingPos, appearance, randomSource);
            if (!updatedState.equals((Object)t.getHeldState())) {
                t.setHeldState(updatedState);
            }
        });
        return super.method_9559(blockState, levelReader, scheduledTickAccess, currentPos, direction, facingPos, facingState, randomSource);
    }

    protected abstract class_2680 getAppearance(class_2680 var1, class_4538 var2, class_2338 var3, class_2350 var4, class_2680 var5, class_2338 var6);

    public boolean method_9506(class_2680 state) {
        return true;
    }

    public int method_9524(class_2680 state, class_1922 reader, class_2338 pos, class_2350 direction) {
        return this.getHeldState(reader, pos).map(s -> s.method_26195(reader, pos, direction)).orElse(super.method_9524(state, reader, pos, direction));
    }

    public int method_9603(class_2680 state, class_1922 reader, class_2338 pos, class_2350 direction) {
        return this.getHeldState(reader, pos).map(s -> s.method_26203(reader, pos, direction)).orElse(super.method_9603(state, reader, pos, direction));
    }

    public boolean method_9526(class_2680 state) {
        return true;
    }

    protected boolean method_9579(class_2680 blockState) {
        return true;
    }

    protected int method_9505(class_2680 blockState) {
        return super.method_9505(blockState);
    }

    protected float method_9575(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos) {
        return this.getHeldState(blockGetter, blockPos).map(s -> Float.valueOf(s.method_26210(blockGetter, blockPos))).orElse(Float.valueOf(super.method_9575(blockState, blockGetter, blockPos))).floatValue();
    }

    protected class_265 method_9571(class_2680 blockState) {
        return super.method_9571(blockState);
    }

    public class_1767 getColor() {
        return this.dyeColor;
    }

    private Optional<? extends ElevatorBlockEntityBase> getElevatorTile(class_1922 world, class_2338 pos) {
        if (world == null || pos == null) {
            return Optional.empty();
        }
        return world.method_35230(pos, this.tileEntityType.get());
    }

    protected Optional<class_2680> getHeldState(class_1922 world, class_2338 pos) {
        return this.getElevatorTile(world, pos).map(ElevatorBlockEntityBase::getHeldState);
    }
}

