/*
 * Decompiled with CFR 0.152.
 */
package team.creative.enhancedvisuals.client.type;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.Std140Builder;
import com.mojang.blaze3d.buffers.Std140SizeCalculator;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.ByteBuffer;
import java.util.Map;
import net.minecraft.class_283;
import org.lwjgl.system.MemoryStack;
import team.creative.enhancedvisuals.api.type.VisualTypeFocus;
import team.creative.enhancedvisuals.client.type.VisualTypeShaderClient;
import team.creative.enhancedvisuals.mixin.PostChainAccessor;
import team.creative.enhancedvisuals.mixin.PostPassAccessor;

public class VisualTypeFocusClient
extends VisualTypeShaderClient<VisualTypeFocus> {
    private static final int UNIFORM_SIZE = new Std140SizeCalculator().putFloat().get();

    public VisualTypeFocusClient(VisualTypeFocus type) {
        super(type);
    }

    @Override
    public void changeProperties(float intensity) {
        for (class_283 pass : ((PostChainAccessor)this.postChain).getPasses()) {
            Map<String, GpuBuffer> uniforms = ((PostPassAccessor)pass).getCustomUniforms();
            uniforms.compute("RadiusConfig", (key, buffer) -> {
                if (buffer == null) {
                    buffer = RenderSystem.getDevice().createBuffer(() -> "Blobs2 / RadiusConfig", 136, UNIFORM_SIZE);
                }
                try (MemoryStack memoryStack = MemoryStack.stackPush();){
                    ByteBuffer byteBuffer = Std140Builder.onStack((MemoryStack)memoryStack, (int)UNIFORM_SIZE).putFloat(intensity).get();
                    RenderSystem.getDevice().createCommandEncoder().writeToBuffer(buffer.slice(), byteBuffer);
                }
                return buffer;
            });
        }
    }
}

