/*
 * Decompiled with CFR 0.152.
 */
package team.creative.enhancedvisuals.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1113;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import team.creative.creativecore.common.config.premade.IntMinMax;
import team.creative.creativecore.common.config.premade.curve.Curve;
import team.creative.creativecore.common.config.premade.curve.DecimalCurve;
import team.creative.creativecore.common.util.type.Color;
import team.creative.creativecore.common.util.type.map.HashMapList;
import team.creative.enhancedvisuals.EVManager;
import team.creative.enhancedvisuals.EnhancedVisuals;
import team.creative.enhancedvisuals.api.Particle;
import team.creative.enhancedvisuals.api.Visual;
import team.creative.enhancedvisuals.api.VisualCategory;
import team.creative.enhancedvisuals.api.VisualHandler;
import team.creative.enhancedvisuals.api.type.VisualType;
import team.creative.enhancedvisuals.client.EVClient;
import team.creative.enhancedvisuals.client.sound.PositionedSound;
import team.creative.enhancedvisuals.client.sound.SoundMuteHandler;
import team.creative.enhancedvisuals.client.sound.TickedSound;
import team.creative.enhancedvisuals.client.type.VisualTypeClient;
import team.creative.enhancedvisuals.common.event.EVEvents;
import team.creative.enhancedvisuals.common.visual.VisualRegistry;

public class EVManagerClient
implements EVManager {
    private final Random random = new Random();
    private HashMapList<VisualCategory, Visual> visuals = new HashMapList();
    private List<TickedSound> playing = new ArrayList<TickedSound>();

    public void respawn() {
        this.clearEverything();
    }

    public void clientTick() {
        if (EVClient.shouldTick()) {
            class_746 player = class_310.method_1551().field_1724;
            this.onTick((class_1657)player);
        }
        SoundMuteHandler.tick();
    }

    @Override
    public Random random() {
        return this.random;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTick(@Nullable class_1657 player) {
        boolean areEyesInWater = player != null && EVEvents.areEyesInWater(player);
        HashMapList<VisualCategory, Visual> hashMapList = this.visuals;
        synchronized (hashMapList) {
            Iterator iterator = this.visuals.iterator();
            block3: while (iterator.hasNext()) {
                Visual visual = (Visual)iterator.next();
                int factor = 1;
                if (areEyesInWater && visual.isAffectedByWater()) {
                    factor = EnhancedVisuals.CONFIG.waterSubstractFactor;
                }
                for (int i = 0; i < factor; ++i) {
                    if (visual.tick()) continue;
                    visual.removeFromDisplay();
                    iterator.remove();
                    continue block3;
                }
            }
            for (VisualHandler handler : VisualRegistry.handlers()) {
                if (!handler.isEnabled(player)) continue;
                handler.tick(player);
            }
        }
        if (player != null && !player.method_5805()) {
            this.clearEverything();
        }
        if (!this.playing.isEmpty()) {
            this.playing.removeIf(x -> x.method_4793());
        }
    }

    @Override
    public void playSound(class_2960 location) {
        this.playSound(location, null, 1.0f);
    }

    @Override
    public void playSound(class_2960 location, class_2338 pos) {
        this.playSound(location, pos, 1.0f);
    }

    @Override
    public void playSound(class_2960 location, float volume) {
        this.playSound(location, null, volume);
    }

    @Override
    public void playSound(class_2960 location, class_2338 pos, float volume) {
        if (!EVClient.shouldRender()) {
            return;
        }
        if (pos != null) {
            class_310.method_1551().method_1483().method_4873((class_1113)new PositionedSound(location, class_3419.field_15250, volume, 1.0f, pos));
        } else {
            class_310.method_1551().method_1483().method_4873((class_1113)new PositionedSound(location, class_3419.field_15250, volume, 1.0f));
        }
    }

    @Override
    public void playSoundFadeOut(class_2960 location, class_2338 pos, DecimalCurve volume) {
        if (!EVClient.shouldRender()) {
            return;
        }
        this.playTicking(location, pos, volume);
    }

    @Override
    public Collection<Visual> visuals(VisualCategory category) {
        return this.visuals.get((Object)category);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearEverything() {
        HashMapList<VisualCategory, Visual> hashMapList = this.visuals;
        synchronized (hashMapList) {
            this.visuals.removeKey((Object)VisualCategory.particle);
        }
        if (!this.playing.isEmpty()) {
            for (TickedSound sound : this.playing) {
                sound.stop();
            }
            this.playing.clear();
            SoundMuteHandler.endMuting();
        }
    }

    @Override
    public void add(Visual visual) {
        if (!visual.type.disabled) {
            visual.addToDisplay();
            this.visuals.add((Object)visual.getCategory(), (Object)visual);
        }
    }

    @Override
    public boolean remove(Visual visual) {
        if (this.visuals.removeValue((Object)visual.getCategory(), (Object)visual)) {
            visual.removeFromDisplay();
            return true;
        }
        return false;
    }

    @Override
    public void playTicking(class_2960 location, class_2338 pos, DecimalCurve volume) {
        TickedSound sound = pos != null ? new TickedSound(location, class_3419.field_15250, 1.0f, pos, volume) : new TickedSound(location, class_3419.field_15250, 1.0f, volume);
        this.playing.add(sound);
        class_310.method_1551().method_1483().method_4873((class_1113)sound);
    }

    @Override
    public Visual addVisualFadeOut(VisualType vt, VisualHandler handler, IntMinMax time) {
        return this.addVisualFadeOut(vt, handler, (Curve)new DecimalCurve(0.0, 1.0, (double)time.next(this.random), 0.0));
    }

    @Override
    public Visual addVisualFadeOut(VisualType vt, VisualHandler handler, int time) {
        return this.addVisualFadeOut(vt, handler, (Curve)new DecimalCurve(0.0, 1.0, (double)time, 0.0));
    }

    @Override
    public Visual addVisualFadeOut(VisualType vt, VisualHandler handler, Curve curve) {
        VisualTypeClient ct = EVClient.get(vt);
        Visual v = new Visual(vt, handler, curve, ct.getVariantAmount() > 1 ? this.random.nextInt(ct.getVariantAmount()) : 0);
        this.add(v);
        return v;
    }

    @Override
    public void addParticlesFadeOut(VisualType vt, VisualHandler handler, int count, IntMinMax time, boolean rotate) {
        this.addParticlesFadeOut(vt, handler, count, (Curve)new DecimalCurve(0.0, 1.0, (double)time.next(this.random), 0.0), rotate, null);
    }

    @Override
    public void addParticlesFadeOut(VisualType vt, VisualHandler handler, int count, IntMinMax time, boolean rotate, @Nullable Color color) {
        this.addParticlesFadeOut(vt, handler, count, (Curve)new DecimalCurve(0.0, 1.0, (double)time.next(this.random), 0.0), rotate, color);
    }

    @Override
    public void addParticlesFadeOut(VisualType vt, VisualHandler handler, int count, int time, boolean rotate) {
        this.addParticlesFadeOut(vt, handler, count, (Curve)new DecimalCurve(0.0, 1.0, (double)time, 0.0), rotate, null);
    }

    @Override
    public void addParticlesFadeOut(VisualType vt, VisualHandler handler, int count, Curve curve, boolean rotate, @Nullable Color color) {
        if (vt.disabled) {
            return;
        }
        VisualTypeClient ct = EVClient.get(vt);
        class_310 mc = class_310.method_1551();
        for (int i = 0; i < count; ++i) {
            int screenWidth = mc.method_22683().method_4489();
            int screenHeight = mc.method_22683().method_4506();
            int width = ct.getWidth(screenWidth, screenHeight);
            int height = ct.getHeight(screenWidth, screenHeight);
            if (vt.scaleVariants()) {
                double scale = vt.randomScale(this.random);
                width = (int)((double)width * scale);
                height = (int)((double)height * scale);
            }
            Particle particle = new Particle(vt, handler, curve, this.generateOffset(this.random, screenWidth, width), this.generateOffset(this.random, screenHeight, height), width, height, vt.canRotate() && rotate ? this.random.nextFloat() * 360.0f : 0.0f, this.random.nextInt(ct.getVariantAmount()));
            if (color != null) {
                particle.color = color;
            }
            this.add(particle);
        }
    }

    @Override
    public Particle addParticle(VisualType vt, VisualHandler handler, boolean rotate, @Nullable Color color) {
        class_310 mc = class_310.method_1551();
        int screenWidth = mc.method_22683().method_4489();
        int screenHeight = mc.method_22683().method_4506();
        VisualTypeClient ct = EVClient.get(vt);
        int width = ct.getWidth(screenWidth, screenHeight);
        int height = ct.getHeight(screenWidth, screenHeight);
        if (vt.scaleVariants()) {
            double scale = vt.randomScale(this.random);
            width = (int)((double)width * scale);
            height = (int)((double)height * scale);
        }
        Particle particle = new Particle(vt, handler, this.generateOffset(this.random, screenWidth, width), this.generateOffset(this.random, screenHeight, height), width, height, vt.canRotate() && rotate ? this.random.nextFloat() * 360.0f : 0.0f, this.random.nextInt(ct.getVariantAmount()));
        particle.setOpacityInternal(1.0f);
        if (color != null) {
            particle.color = color;
        }
        this.add(particle);
        return particle;
    }

    @Override
    public int generateOffset(Random rand, int dimensionLength, int spacingBuffer) {
        int half = dimensionLength / 2;
        float multiplier = (float)(1.0 - Math.pow(rand.nextDouble(), 2.0));
        float textureCenterPosition = rand.nextInt(2) == 0 ? (float)half + (float)half * multiplier : (float)half - (float)half * multiplier;
        return (int)(textureCenterPosition - (float)spacingBuffer / 2.0f);
    }
}

