/*
 * Decompiled with CFR 0.152.
 */
package io.github.yxmna.fancydooranim.render;

import io.github.yxmna.fancydooranim.DoorAnimMath;
import io.github.yxmna.fancydooranim.DoorAnimationTracker;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1920;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_638;
import net.minecraft.class_761;
import net.minecraft.class_776;
import net.minecraft.class_7833;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public final class DoorAnimatedOverlay {
    private static final double EPS = 5.0E-4;

    private DoorAnimatedOverlay() {
    }

    public static void renderAll(class_638 world, class_4587 ms, class_243 cameraPos, class_4597 consumers) {
        class_310 mc = class_310.method_1551();
        if (mc == null || world == null || consumers == null) {
            return;
        }
        class_776 brm = mc.method_1541();
        DoorAnimationTracker.forEachActive((pos, entry) -> {
            Float angleDeg = DoorAnimationTracker.computeAngleDeg(pos);
            if (angleDeg == null) {
                return;
            }
            class_2680 worldState = world.method_8320(pos);
            if (!(worldState.method_26204() instanceof class_2323)) {
                return;
            }
            class_2680 lowerClosed = (class_2680)((class_2680)((class_2680)((class_2680)worldState.method_11657((class_2769)class_2741.field_12533, (Comparable)class_2756.field_12607)).method_11657((class_2769)class_2741.field_12537, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)class_2741.field_12520, (Comparable)entry.hinge)).method_11657((class_2769)class_2741.field_12481, (Comparable)entry.facing);
            class_2680 upperClosed = (class_2680)lowerClosed.method_11657((class_2769)class_2741.field_12533, (Comparable)class_2756.field_12609);
            DoorAnimatedOverlay.renderHalfRotated((class_1920)world, brm, consumers, ms, cameraPos, pos, lowerClosed, angleDeg.floatValue(), entry);
            DoorAnimatedOverlay.renderHalfRotated((class_1920)world, brm, consumers, ms, cameraPos, pos.method_10084(), upperClosed, angleDeg.floatValue(), entry);
        });
    }

    private static void renderHalfRotated(class_1920 world, class_776 brm, class_4597 consumers, class_4587 ms, class_243 cam, class_2338 pos, class_2680 stateClosed, float angleDeg, DoorAnimationTracker.Entry entry) {
        ms.method_22903();
        double x = (double)pos.method_10263() - cam.field_1352;
        double y = (double)pos.method_10264() - cam.field_1351;
        double z = (double)pos.method_10260() - cam.field_1350;
        double dxCam = cam.field_1352 - ((double)pos.method_10263() + 0.5);
        double dzCam = cam.field_1350 - ((double)pos.method_10260() + 0.5);
        double len = Math.sqrt(dxCam * dxCam + dzCam * dzCam);
        double ex = len > 1.0E-6 ? dxCam / len * 5.0E-4 : 0.0;
        double ez = len > 1.0E-6 ? dzCam / len * 5.0E-4 : 0.0;
        ms.method_22904(x + ex, y, z + ez);
        DoorAnimMath.Inset inset = DoorAnimMath.lateralInsetTowardHinge(entry.facing, entry.hinge, angleDeg);
        ms.method_22904((double)inset.dx, 0.0, (double)inset.dz);
        DoorAnimMath.Pivot p = DoorAnimMath.hingePivot(entry.facing, entry.hinge);
        ms.method_22904((double)p.x, 0.0, (double)p.z);
        ms.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(angleDeg));
        ms.method_22904((double)(-p.x), 0.0, (double)(-p.z));
        int light = class_761.method_23794((class_1920)world, (class_2338)pos);
        brm.method_3353(stateClosed, ms, consumers, light, class_4608.field_21444);
        ms.method_22909();
    }
}

