/*
 * Decompiled with CFR 0.152.
 */
package fuzs.effectinsights.client.handler;

import fuzs.effectinsights.EffectInsights;
import fuzs.effectinsights.client.gui.tooltip.MobEffectTooltipLines;
import fuzs.effectinsights.config.ClientConfig;
import fuzs.puzzleslib.api.client.gui.v2.ScreenHelper;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.data.MutableBoolean;
import fuzs.puzzleslib.api.event.v1.data.MutableInt;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1293;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_465;
import org.jetbrains.annotations.Nullable;

public class EffectWidgetHandler {
    @Nullable
    private static List<class_2561> tooltipLines;

    public static EventResult onInventoryMobEffects(class_437 screen, int availableSpace, MutableBoolean smallWidgets, MutableInt horizontalOffset) {
        class_1293 mobEffect;
        if (!((ClientConfig)EffectInsights.CONFIG.get(ClientConfig.class)).effectWidgetTooltips.widgetTooltips()) {
            return EventResult.PASS;
        }
        if (!(screen instanceof class_465)) {
            return EventResult.PASS;
        }
        class_465 abstractContainerScreen = (class_465)screen;
        if (EffectWidgetHandler.isInWidgetsColumn(horizontalOffset.getAsInt(), smallWidgets.getAsBoolean()) && (mobEffect = EffectWidgetHandler.getMobEffectInRow(abstractContainerScreen)) != null) {
            tooltipLines = MobEffectTooltipLines.getMobEffectWidgetTooltipLines(mobEffect);
        }
        return EventResult.PASS;
    }

    public static void onAfterBackground(class_465<?> screen, class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (!((ClientConfig)EffectInsights.CONFIG.get(ClientConfig.class)).effectWidgetTooltips.widgetTooltips()) {
            return;
        }
        if (tooltipLines != null) {
            guiGraphics.method_64038(screen.method_64506(), tooltipLines, Optional.empty(), mouseX, mouseY);
            tooltipLines = null;
        }
    }

    private static boolean isInWidgetsColumn(int horizontalOffset, boolean smallWidgets) {
        int mouseX = ScreenHelper.getMouseX();
        int widgetWidth = !smallWidgets ? 121 : 33;
        return mouseX >= horizontalOffset && mouseX <= horizontalOffset + widgetWidth;
    }

    private static class_1293 getMobEffectInRow(class_465<?> screen) {
        int mouseY = ScreenHelper.getMouseY();
        int posY = screen.field_2800;
        Collection<class_1293> mobEffects = EffectWidgetHandler.getVisibleMobEffects();
        int verticalOffset = EffectWidgetHandler.getVerticalOffset(mobEffects);
        class_1293 hoveredMobEffect = null;
        for (class_1293 mobEffect : mobEffects) {
            if (mouseY >= posY && mouseY <= posY + verticalOffset) {
                hoveredMobEffect = mobEffect;
            }
            posY += verticalOffset;
        }
        return hoveredMobEffect;
    }

    private static Collection<class_1293> getVisibleMobEffects() {
        return class_310.method_1551().field_1724.method_6026().stream().filter(ScreenHelper::isEffectVisibleInInventory).sorted().toList();
    }

    private static int getVerticalOffset(Collection<class_1293> mobEffects) {
        if (mobEffects.size() > 5) {
            return 132 / (mobEffects.size() - 1);
        }
        return 33;
    }

    public static void onGatherEffectScreenTooltip(class_465<?> screen, class_1293 mobEffectInstance, List<class_2561> tooltipLines) {
        if (((ClientConfig)EffectInsights.CONFIG.get(ClientConfig.class)).effectWidgetTooltips.widgetTooltips()) {
            tooltipLines.clear();
        }
    }
}

