/*
 * Decompiled with CFR 0.152.
 */
package fuzs.effectinsights.client.gui.tooltip;

import com.google.common.collect.ImmutableList;
import fuzs.effectinsights.EffectInsights;
import fuzs.effectinsights.client.gui.tooltip.PotionContentsLines;
import fuzs.effectinsights.config.ClientConfig;
import fuzs.tooltipinsights.api.v1.client.gui.tooltip.DescriptionLines;
import fuzs.tooltipinsights.api.v1.client.gui.tooltip.InternalNameLines;
import fuzs.tooltipinsights.api.v1.client.gui.tooltip.ModNameLines;
import fuzs.tooltipinsights.api.v1.client.gui.tooltip.TooltipLinesExtractor;
import fuzs.tooltipinsights.api.v1.config.AbstractClientConfig;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1293;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5321;

public final class MobEffectTooltipLines {
    static final TooltipLinesExtractor<class_1293, ClientConfig.EffectTooltipComponents> DISPLAY_NAME = new PotionContentsLines(){

        protected boolean isEnabled(ClientConfig.EffectTooltipComponents tooltipComponents) {
            return tooltipComponents.displayName;
        }

        @Override
        protected Stream<class_2561> modifyTooltipLines(List<class_2561> tooltipLines, int separatorIndex) {
            if (separatorIndex != -1) {
                return tooltipLines.subList(0, separatorIndex).stream();
            }
            return tooltipLines.stream();
        }
    };
    static final TooltipLinesExtractor<class_1293, AbstractClientConfig.TooltipComponents> DESCRIPTION = new DescriptionLines<class_1293>(){

        protected String getDescriptionId(class_1293 mobEffect) {
            return mobEffect.method_5586();
        }
    };
    static final TooltipLinesExtractor<class_1293, AbstractClientConfig.TooltipComponents> MOD_NAME = new ModNameLines<class_1293>(){

        protected class_5321<?> getResourceKey(class_1293 mobEffect) {
            return (class_5321)mobEffect.method_5579().method_40230().orElseThrow();
        }
    };
    static final TooltipLinesExtractor<class_1293, AbstractClientConfig.TooltipComponents> INTERNAL_NAME = new InternalNameLines<class_1293>(){

        protected class_5321<?> getResourceKey(class_1293 mobEffect) {
            return (class_5321)mobEffect.method_5579().method_40230().orElseThrow();
        }
    };
    static final TooltipLinesExtractor<class_1293, ClientConfig.EffectTooltipComponents> ATTRIBUTES = new PotionContentsLines(){

        protected boolean isEnabled(ClientConfig.EffectTooltipComponents tooltipComponents) {
            return tooltipComponents.effectAttributes;
        }

        @Override
        protected Stream<class_2561> modifyTooltipLines(List<class_2561> tooltipLines, int separatorIndex) {
            if (separatorIndex != -1) {
                return tooltipLines.subList(separatorIndex, tooltipLines.size()).stream();
            }
            return Stream.empty();
        }
    };
    static final List<TooltipLinesExtractor<class_1293, AbstractClientConfig.TooltipComponents>> ITEM_SUPPLIERS = ImmutableList.of(DESCRIPTION, MOD_NAME, INTERNAL_NAME);
    static final List<TooltipLinesExtractor<class_1293, ClientConfig.EffectTooltipComponents>> WIDGET_SUPPLIERS = ImmutableList.of(DISPLAY_NAME, (Object)DESCRIPTION.cast(), (Object)MOD_NAME.cast(), (Object)INTERNAL_NAME.cast(), ATTRIBUTES);

    private MobEffectTooltipLines() {
    }

    public static List<class_2561> getMobEffectItemTooltipLines(class_1293 mobEffect) {
        return TooltipLinesExtractor.getTooltipLines(ITEM_SUPPLIERS, (class_2561)((ClientConfig)EffectInsights.CONFIG.get(ClientConfig.class)).effectItemTooltips.decorationComponent, (class_2583)((ClientConfig)EffectInsights.CONFIG.get(ClientConfig.class)).effectItemTooltips.decorationStyle, (Object)mobEffect, (AbstractClientConfig.TooltipComponents)((ClientConfig)EffectInsights.CONFIG.get(ClientConfig.class)).effectItemTooltips.itemTooltipLines);
    }

    public static List<class_2561> getMobEffectWidgetTooltipLines(class_1293 mobEffect) {
        return TooltipLinesExtractor.getTooltipLines(WIDGET_SUPPLIERS, (class_2561)((ClientConfig)EffectInsights.CONFIG.get(ClientConfig.class)).effectWidgetTooltips.decorationComponent, (class_2583)((ClientConfig)EffectInsights.CONFIG.get(ClientConfig.class)).effectWidgetTooltips.decorationStyle, (Object)mobEffect, (AbstractClientConfig.TooltipComponents)((ClientConfig)EffectInsights.CONFIG.get(ClientConfig.class)).effectWidgetTooltips.widgetTooltipLines);
    }
}

