/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.codecs.yabn;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.ListBuilder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.teamresourceful.resourcefullib.common.codecs.yabn.YabnArrayBuilder;
import com.teamresourceful.resourcefullib.common.codecs.yabn.YabnObjectMapLike;
import com.teamresourceful.resourcefullib.common.codecs.yabn.YabnRecordBuilder;
import com.teamresourceful.yabn.YabnCompressor;
import com.teamresourceful.yabn.elements.YabnArray;
import com.teamresourceful.yabn.elements.YabnElement;
import com.teamresourceful.yabn.elements.YabnObject;
import com.teamresourceful.yabn.elements.YabnPrimitive;
import com.teamresourceful.yabn.elements.primitives.BooleanContents;
import com.teamresourceful.yabn.elements.primitives.ByteContents;
import com.teamresourceful.yabn.elements.primitives.DoubleContents;
import com.teamresourceful.yabn.elements.primitives.FloatContents;
import com.teamresourceful.yabn.elements.primitives.IntContents;
import com.teamresourceful.yabn.elements.primitives.LongContents;
import com.teamresourceful.yabn.elements.primitives.PrimitiveContents;
import com.teamresourceful.yabn.elements.primitives.PrimitiveNumberContents;
import com.teamresourceful.yabn.elements.primitives.ShortContents;
import com.teamresourceful.yabn.elements.primitives.StringContents;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class YabnOps
implements DynamicOps<YabnElement> {
    public static final YabnOps INSTANCE = new YabnOps(false);
    public static final YabnOps COMPRESSED = new YabnOps(true);
    private final boolean compressed;

    protected YabnOps(boolean compressed) {
        this.compressed = compressed;
    }

    public YabnElement empty() {
        return YabnPrimitive.ofNull();
    }

    public <U> U convertTo(DynamicOps<U> outOps, YabnElement input) {
        if (input instanceof YabnObject) {
            return (U)this.convertMap(outOps, input);
        }
        if (input instanceof YabnArray) {
            return (U)this.convertList(outOps, input);
        }
        if (this.compressed) {
            input = YabnCompressor.compress((YabnElement)input);
        }
        if (input.isNull()) {
            return (U)outOps.empty();
        }
        if (input instanceof YabnPrimitive) {
            YabnPrimitive primitive = (YabnPrimitive)input;
            PrimitiveContents contents = primitive.contents();
            if (contents instanceof StringContents) {
                StringContents stringContents = (StringContents)contents;
                return (U)outOps.createString(stringContents.value());
            }
            if (contents instanceof BooleanContents) {
                BooleanContents booleanContents = (BooleanContents)contents;
                return (U)outOps.createBoolean(booleanContents.value());
            }
            if (contents instanceof ByteContents) {
                ByteContents byteContents = (ByteContents)contents;
                return (U)outOps.createByte(byteContents.value());
            }
            if (contents instanceof ShortContents) {
                ShortContents shortContents = (ShortContents)contents;
                return (U)outOps.createShort(shortContents.value());
            }
            if (contents instanceof IntContents) {
                IntContents intContents = (IntContents)contents;
                return (U)outOps.createInt(intContents.value());
            }
            if (contents instanceof LongContents) {
                LongContents longContents = (LongContents)contents;
                return (U)outOps.createLong(longContents.value());
            }
            if (contents instanceof DoubleContents) {
                DoubleContents doubleContents = (DoubleContents)contents;
                return (U)outOps.createDouble(doubleContents.value());
            }
            if (contents instanceof FloatContents) {
                FloatContents floatContents = (FloatContents)contents;
                return (U)outOps.createFloat(floatContents.value());
            }
            throw new IllegalStateException("Unknown primitive contents: " + String.valueOf(contents));
        }
        throw new IllegalArgumentException("Unknown type: " + String.valueOf(input.getClass()));
    }

    public DataResult<Number> getNumberValue(YabnElement input) {
        if (input instanceof YabnPrimitive) {
            YabnPrimitive primitive = (YabnPrimitive)input;
            PrimitiveContents contents = primitive.contents();
            if (contents instanceof PrimitiveNumberContents) {
                PrimitiveNumberContents num = (PrimitiveNumberContents)contents;
                return DataResult.success((Object)num.getValue());
            }
            if (contents instanceof BooleanContents) {
                BooleanContents bool = (BooleanContents)contents;
                return DataResult.success((Object)(bool.value() ? 1 : 0));
            }
            if (this.compressed && contents instanceof StringContents) {
                StringContents str = (StringContents)contents;
                try {
                    return DataResult.success((Object)Integer.parseInt(str.value()));
                }
                catch (NumberFormatException e) {
                    return DataResult.error(() -> "Not a number: " + String.valueOf(e) + " " + String.valueOf(input));
                }
            }
        }
        return DataResult.error(() -> "Not a number: " + String.valueOf(input));
    }

    public YabnElement createNumeric(Number i) {
        BigDecimal value = new BigDecimal(i.toString());
        try {
            return YabnCompressor.compressNonFloatingNumber((long)value.longValueExact());
        }
        catch (ArithmeticException e) {
            return YabnCompressor.compressFloatingNumber((double)value.doubleValue());
        }
    }

    public DataResult<Boolean> getBooleanValue(YabnElement input) {
        if (input instanceof YabnPrimitive) {
            YabnPrimitive primitive = (YabnPrimitive)input;
            PrimitiveContents contents = primitive.contents();
            if (contents instanceof BooleanContents) {
                BooleanContents bool = (BooleanContents)contents;
                return DataResult.success((Object)bool.value());
            }
            if (contents instanceof PrimitiveNumberContents) {
                PrimitiveNumberContents num = (PrimitiveNumberContents)contents;
                return DataResult.success((Object)(num.getAsByte() != 0 ? 1 : 0));
            }
        }
        return DataResult.error(() -> "Not a boolean: " + String.valueOf(input));
    }

    public YabnElement createBoolean(boolean value) {
        return YabnPrimitive.ofBoolean((boolean)value);
    }

    public DataResult<String> getStringValue(YabnElement input) {
        if (input instanceof YabnPrimitive) {
            YabnPrimitive primitive = (YabnPrimitive)input;
            PrimitiveContents primitiveContents = primitive.contents();
            if (primitiveContents instanceof StringContents) {
                StringContents contents = (StringContents)primitiveContents;
                return DataResult.success((Object)contents.value());
            }
            if (this.compressed && (primitiveContents = primitive.contents()) instanceof PrimitiveNumberContents) {
                PrimitiveNumberContents contents = (PrimitiveNumberContents)primitiveContents;
                return DataResult.success((Object)contents.getValue().toString());
            }
        }
        return DataResult.error(() -> "Not a string: " + String.valueOf(input));
    }

    public YabnElement createString(String value) {
        return YabnPrimitive.ofString((String)value);
    }

    public DataResult<YabnElement> mergeToList(YabnElement list, YabnElement value) {
        return this.mergeToList(list, List.of(value));
    }

    public DataResult<YabnElement> mergeToList(YabnElement list, List<YabnElement> values) {
        if (!(list instanceof YabnArray) && list != this.empty()) {
            return DataResult.error(() -> "Not a list: " + String.valueOf(list));
        }
        YabnArray array = new YabnArray();
        if (list instanceof YabnArray) {
            YabnArray oldArray = (YabnArray)list;
            oldArray.elements().forEach(arg_0 -> ((YabnArray)array).add(arg_0));
        }
        values.forEach(arg_0 -> ((YabnArray)array).add(arg_0));
        return DataResult.success((Object)array);
    }

    public DataResult<YabnElement> mergeToMap(YabnElement map, YabnElement key, YabnElement value) {
        YabnPrimitive primitive;
        if (!(map instanceof YabnObject) && map != this.empty()) {
            return DataResult.error(() -> "Not a map: " + String.valueOf(map), (Object)map);
        }
        if (!(key instanceof YabnPrimitive) || (primitive = (YabnPrimitive)key).isNull() || !(primitive.contents() instanceof StringContents) && !this.compressed) {
            return DataResult.error(() -> "key is not a string: " + String.valueOf(key), (Object)map);
        }
        YabnObject object = new YabnObject();
        if (map instanceof YabnObject) {
            YabnObject oldObject = (YabnObject)map;
            oldObject.elements().forEach((arg_0, arg_1) -> ((YabnObject)object).put(arg_0, arg_1));
        }
        object.elements().put(YabnOps.getAsString(primitive), value);
        return DataResult.success((Object)object);
    }

    public DataResult<YabnElement> mergeToMap(YabnElement map, MapLike<YabnElement> values) {
        if (!(map instanceof YabnObject) && map != this.empty()) {
            return DataResult.error(() -> "Not a map: " + String.valueOf(map), (Object)map);
        }
        YabnObject object = new YabnObject();
        if (map instanceof YabnObject) {
            YabnObject oldObject = (YabnObject)map;
            oldObject.elements().forEach((arg_0, arg_1) -> ((YabnObject)object).put(arg_0, arg_1));
        }
        ArrayList missed = Lists.newArrayList();
        values.entries().forEach(entry -> {
            YabnPrimitive primitive;
            YabnElement key = (YabnElement)entry.getFirst();
            if (!(key instanceof YabnPrimitive) || (primitive = (YabnPrimitive)key).isNull() || !(primitive.contents() instanceof StringContents) && !this.compressed) {
                missed.add(key);
                return;
            }
            object.put(YabnOps.getAsString(primitive), (YabnElement)entry.getSecond());
        });
        return !missed.isEmpty() ? DataResult.error(() -> "some keys are not strings: " + String.valueOf(missed), (Object)object) : DataResult.success((Object)object);
    }

    public DataResult<Stream<Pair<YabnElement, YabnElement>>> getMapValues(YabnElement input) {
        if (input instanceof YabnObject) {
            YabnObject object = (YabnObject)input;
            Stream<Pair> output = object.elements().entrySet().stream().map(entry -> Pair.of((Object)this.createString((String)entry.getKey()), (Object)((YabnElement)entry.getValue())));
            return DataResult.success(output);
        }
        return DataResult.error(() -> "Not a YABN Object: " + String.valueOf(input));
    }

    public DataResult<Consumer<BiConsumer<YabnElement, YabnElement>>> getMapEntries(YabnElement input) {
        if (input instanceof YabnObject) {
            YabnObject object = (YabnObject)input;
            return DataResult.success(c -> object.elements().forEach((key, value) -> c.accept(this.createString((String)key), value)));
        }
        return DataResult.error(() -> "Not a YABN Object: " + String.valueOf(input));
    }

    public DataResult<MapLike<YabnElement>> getMap(YabnElement input) {
        DataResult dataResult;
        if (input instanceof YabnObject) {
            YabnObject object = (YabnObject)input;
            dataResult = DataResult.success((Object)new YabnObjectMapLike(object));
        } else {
            dataResult = DataResult.error(() -> "Not a YABN Object: " + String.valueOf(input));
        }
        return dataResult;
    }

    public YabnElement createMap(Stream<Pair<YabnElement, YabnElement>> map) {
        YabnObject object = new YabnObject();
        map.forEach(p -> object.put((String)this.getStringValue((YabnElement)p.getFirst()).result().get(), (YabnElement)p.getSecond()));
        return object;
    }

    public DataResult<Stream<YabnElement>> getStream(YabnElement input) {
        if (input instanceof YabnArray) {
            YabnArray array = (YabnArray)input;
            return DataResult.success(array.elements().stream());
        }
        return DataResult.error(() -> "Not a YABN Array: " + String.valueOf(input));
    }

    public DataResult<Consumer<Consumer<YabnElement>>> getList(YabnElement input) {
        if (input instanceof YabnArray) {
            YabnArray array = (YabnArray)input;
            return DataResult.success(c -> array.elements().forEach(c));
        }
        return DataResult.error(() -> "Not a YABN Array: " + String.valueOf(input));
    }

    public YabnElement createList(Stream<YabnElement> input) {
        YabnArray array = new YabnArray();
        input.forEach(arg_0 -> ((YabnArray)array).add(arg_0));
        return array;
    }

    public YabnElement remove(YabnElement input, String key) {
        if (input instanceof YabnObject) {
            YabnObject object = (YabnObject)input;
            object.elements().remove(key);
        }
        return input;
    }

    public String toString() {
        return "YABN";
    }

    public ListBuilder<YabnElement> listBuilder() {
        return new YabnArrayBuilder();
    }

    public boolean compressMaps() {
        return this.compressed;
    }

    public RecordBuilder<YabnElement> mapBuilder() {
        return new YabnRecordBuilder(this);
    }

    public static String getAsString(YabnPrimitive primitive) {
        PrimitiveContents contents = primitive.contents();
        if (contents instanceof StringContents) {
            StringContents stringContents = (StringContents)contents;
            return stringContents.value();
        }
        if (contents instanceof PrimitiveNumberContents) {
            PrimitiveNumberContents numberContents = (PrimitiveNumberContents)contents;
            return numberContents.getValue().toString();
        }
        if (contents instanceof BooleanContents) {
            BooleanContents booleanContents = (BooleanContents)contents;
            return booleanContents.value() ? "true" : "false";
        }
        return null;
    }
}

