/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_6383;
import net.minecraft.class_6384;
import net.minecraft.class_7847;
import net.minecraft.class_8021;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.ITooltip;
import snownee.jade.api.ui.Element;
import snownee.jade.api.ui.JadeUI;
import snownee.jade.api.ui.ScreenDirection;
import snownee.jade.api.ui.TextElement;
import snownee.jade.impl.ui.JadeUIInternal;

public class Tooltip
implements ITooltip {
    public final List<Line> lines = new ArrayList<Line>();
    public boolean sneakyDetails;
    @Nullable
    public Element icon;

    private static class_2960 getTag(class_8021 element) {
        if (element instanceof Element) {
            Element taggable = (Element)element;
            return taggable.getTag();
        }
        return null;
    }

    @Override
    public void clear() {
        this.lines.clear();
    }

    @Override
    public int size() {
        return this.lines.size();
    }

    @Override
    public void append(int index, class_8021 element) {
        Element taggable;
        if (element instanceof Element && (taggable = (Element)element).getTag() == null) {
            taggable.tag(JadeUIInternal.contextUid());
        }
        if (this.isEmpty() || index == this.size()) {
            this.add(element);
        } else {
            Line line = this.lines.get(index);
            line.elements.add(element);
        }
    }

    @Override
    public void add(int index, class_8021 element) {
        this.lines.add(index, new Line());
        this.append(index, element);
    }

    @Override
    public List<class_8021> get(class_2960 tag) {
        ArrayList elements = Lists.newArrayList();
        for (Line line : this.lines) {
            line.elements().stream().filter(e -> Objects.equal((Object)tag, (Object)Tooltip.getTag(e))).forEach(elements::add);
        }
        return elements;
    }

    @Override
    public boolean remove(class_2960 tag) {
        return this.removeInternal(tag, true, null);
    }

    private boolean removeInternal(class_2960 tag, boolean removeFirstLineIfEmpty, @Nullable List<List<class_8021>> collector) {
        boolean removed = false;
        ArrayList collected = collector == null ? null : Lists.newArrayList();
        Iterator<Line> iterator = this.lines.iterator();
        while (iterator.hasNext()) {
            Line line = iterator.next();
            if (!line.elements.removeIf(e -> {
                if (Objects.equal((Object)tag, (Object)Tooltip.getTag(e))) {
                    if (collector != null) {
                        collected.add(e);
                    }
                    return true;
                }
                return false;
            })) continue;
            if (line.elements.isEmpty() && (removed || removeFirstLineIfEmpty)) {
                iterator.remove();
            }
            removed = true;
            if (collector == null || collected.isEmpty()) continue;
            collector.add(Lists.newArrayList((Iterable)collected));
            collected.clear();
        }
        return removed;
    }

    @Override
    public boolean replace(class_2960 tag, class_2561 component) {
        return this.replace(tag, $ -> List.of(List.of(JadeUI.text(component))));
    }

    @Override
    public boolean replace(class_2960 tag, UnaryOperator<List<List<class_8021>>> operator) {
        int firstX = -1;
        int firstY = -1;
        for (int y = 0; y < this.lines.size(); ++y) {
            Line line = this.lines.get(y);
            for (int x = 0; x < line.elements().size(); ++x) {
                class_8021 element = line.elements().get(x);
                if (!Objects.equal((Object)tag, (Object)Tooltip.getTag(element)) || firstX != -1) continue;
                firstX = x;
                firstY = y;
            }
        }
        if (firstX != -1) {
            List elements = Lists.newArrayList();
            this.removeInternal(tag, false, elements);
            elements = (List)operator.apply(elements);
            for (List elementList : elements) {
                for (class_8021 element : elementList) {
                    Element taggable;
                    if (!(element instanceof Element) || (taggable = (Element)element).getTag() != null) continue;
                    taggable.tag(tag);
                }
            }
            for (int i = 0; i < elements.size(); ++i) {
                List list = (List)elements.get(i);
                if (i == 0) {
                    Line line = this.lines.get(firstY);
                    line.elements().addAll(firstX, list);
                    continue;
                }
                this.add(firstY + i, list);
            }
        }
        return firstX != -1;
    }

    @Override
    public void setLineMargin(int index, ScreenDirection side, int margin) {
        if (index < 0) {
            index += this.lines.size();
        }
        Line line = this.lines.get(index);
        switch (side) {
            case UP: {
                line.marginTop = margin;
                break;
            }
            case DOWN: {
                line.marginBottom = margin;
                break;
            }
            default: {
                throw new IllegalArgumentException("Only TOP and BOTTOM are allowed.");
            }
        }
    }

    @Override
    public void setLineSettings(int index, UnaryOperator<class_7847> settings) {
        if (index < 0) {
            index += this.lines.size();
        }
        Line line = this.lines.get(index);
        line.settings = settings;
    }

    @Override
    public String getNarration() {
        return this.getNarration(line -> true);
    }

    public String getNarration(Predicate<Line> predicate) {
        final StringBuilder sb = new StringBuilder();
        class_6382 output = new class_6382(){

            public void method_37032(class_6381 narratedElementType, class_6384<?> narrationThunk) {
                if (narratedElementType != class_6381.field_33788) {
                    return;
                }
                narrationThunk.method_37039(text -> sb.append((String)text).append(". "));
            }

            @NotNull
            public class_6382 method_37031() {
                return this;
            }
        };
        for (Line line : this.lines) {
            if (!predicate.test(line)) continue;
            boolean hasSupplier = false;
            for (class_8021 element : line.elements()) {
                if (!(element instanceof class_6383)) continue;
                class_6383 supplier = (class_6383)element;
                supplier.method_37020(output);
                hasSupplier = true;
            }
            if (!hasSupplier || sb.isEmpty()) continue;
            sb.append('\n');
        }
        if (sb.isEmpty()) {
            return "";
        }
        if (sb.charAt(sb.length() - 1) == '\n') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    @Override
    public String getString(class_2960 tag) {
        return this.get(tag).stream().filter($ -> $ instanceof TextElement).map($ -> ((TextElement)$).getString()).findFirst().orElse("");
    }

    public void method_37020(class_6382 narrationElementOutput) {
        String narration = this.getNarration();
        if (!narration.isEmpty()) {
            narrationElementOutput.method_37033(class_6381.field_33788, narration);
        }
    }

    @Override
    @Nullable
    public Element getIcon() {
        return this.icon;
    }

    public void setIcon(@Nullable Element icon) {
        this.icon = icon;
    }

    public static class Line {
        private final List<class_8021> elements = Lists.newArrayList();
        public int marginTop = 0;
        public int marginBottom = 2;
        @Nullable
        public UnaryOperator<class_7847> settings;

        public List<class_8021> elements() {
            return this.elements;
        }
    }
}

