/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easymagic.client.util;

import com.google.common.collect.Lists;
import fuzs.easymagic.EasyMagic;
import fuzs.easymagic.config.ServerConfig;
import fuzs.easymagic.util.PlayerExperienceHelper;
import fuzs.easymagic.world.inventory.ModEnchantmentMenu;
import fuzs.puzzleslib.api.client.gui.v2.tooltip.ClientComponentSplitter;
import fuzs.puzzleslib.api.util.v1.ComponentHelper;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_2378;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5348;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_9636;
import org.jetbrains.annotations.Nullable;

public final class EnchantmentTooltipHelper {
    public static final String KEY_ONE_ENCHANT_CATALYST = "container.enchant.lapis.one";
    public static final String KEY_MANY_ENCHANT_CATALYSTS = "container.enchant.lapis.many";
    public static final String KEY_ONE_REROLL_CATALYST = "container.enchant.reroll.one";
    public static final String KEY_MANY_REROLL_CATALYSTS = "container.enchant.reroll.many";
    public static final String KEY_ONE_ENCHANTMENT_LEVEL = "container.enchant.level.one";
    public static final String KEY_MANY_ENCHANTMENT_LEVELS = "container.enchant.level.many";
    public static final String KEY_ONE_EXPERIENCE_POINT = "container.enchant.experience.one";
    public static final String KEY_MANY_EXPERIENCE_POINTS = "container.enchant.experience.many";
    public static final String KEY_REROLL = "container.enchant.reroll";

    private EnchantmentTooltipHelper() {
    }

    public static void gatherSlotEnchantmentsTooltip(List<class_1889> slotData, Consumer<class_2561> tooltipAdder, class_7225.class_7874 registries) {
        Object2IntMap enchantments = (Object2IntMap)slotData.stream().collect(Collectors.toMap(class_1889::comp_3486, class_1889::comp_3487, (o1, o2) -> o2, Object2IntLinkedOpenHashMap::new));
        class_6885 holderSet = EnchantmentTooltipHelper.getTagOrEmpty(registries, class_7924.field_41265, class_9636.field_51362);
        for (class_6880 holder : holderSet) {
            int enchantmentLevel = enchantments.getInt((Object)holder);
            if (enchantmentLevel <= 0) continue;
            EnchantmentTooltipHelper.addTooltipLine((class_6880<class_1887>)holder, enchantmentLevel, tooltipAdder);
        }
        for (Object2IntMap.Entry entry : enchantments.object2IntEntrySet()) {
            if (holderSet.method_40241((class_6880)entry.getKey())) continue;
            EnchantmentTooltipHelper.addTooltipLine((class_6880<class_1887>)((class_6880)entry.getKey()), entry.getIntValue(), tooltipAdder);
        }
    }

    private static void addTooltipLine(class_6880<class_1887> holder, int enchantmentLevel, Consumer<class_2561> tooltipAdder) {
        class_5250 enchantmentComponent = class_2561.method_43473().method_10852(class_1887.method_8179(holder, (int)enchantmentLevel)).method_27692(class_124.field_1080);
        if (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).enchantmentHint == ServerConfig.EnchantmentHint.ALL) {
            tooltipAdder.accept((class_2561)enchantmentComponent);
        } else {
            tooltipAdder.accept((class_2561)class_2561.method_43469((String)"container.enchant.clue", (Object[])new Object[]{enchantmentComponent}));
        }
        EnchantmentTooltipHelper.getEnchantmentDescriptionKey(holder).ifPresent(translationKey -> {
            class_5250 descriptionComponent = class_2561.method_43471((String)translationKey).method_27692(class_124.field_1080);
            ClientComponentSplitter.splitTooltipLines((class_5348[])new class_5348[]{descriptionComponent}).map(ComponentHelper::getAsComponent).forEach(tooltipAdder);
        });
    }

    private static <T> class_6885<T> getTagOrEmpty(@Nullable class_7225.class_7874 registries, class_5321<class_2378<T>> registryKey, class_6862<T> key) {
        Optional optional;
        if (registries != null && (optional = registries.method_46762(registryKey).method_46733(key)).isPresent()) {
            return (class_6885)optional.get();
        }
        return class_6885.method_40246((class_6880[])new class_6880[0]);
    }

    private static Optional<String> getEnchantmentDescriptionKey(class_6880<class_1887> enchantment) {
        String translationKey = enchantment.method_40230().map(resourceKey -> class_156.method_646((String)resourceKey.method_41185().method_12832(), (class_2960)resourceKey.method_29177())).orElse(null);
        if (translationKey == null) {
            return Optional.empty();
        }
        if (class_2477.method_10517().method_4678(translationKey + ".desc")) {
            return Optional.of(translationKey + ".desc");
        }
        if (class_2477.method_10517().method_4678(translationKey + ".description")) {
            return Optional.of(translationKey + ".description");
        }
        return Optional.empty();
    }

    public static void gatherSlotCostsTooltip(int slotIndex, List<class_2561> tooltipLines, class_1657 player, ModEnchantmentMenu menu) {
        ArrayList additionalTooltip = Lists.newArrayList();
        if (!player.method_31549().field_7477) {
            int enchantLevels = menu.field_7808[slotIndex];
            if (player.field_7520 < enchantLevels) {
                additionalTooltip.add(class_2561.method_43469((String)"container.enchant.level.requirement", (Object[])new Object[]{enchantLevels}).method_27692(class_124.field_1061));
            } else {
                EnchantmentTooltipHelper.getEnchantingComponent(slotIndex + 1, menu.method_7638(), KEY_ONE_ENCHANT_CATALYST, KEY_MANY_ENCHANT_CATALYSTS).ifPresent(additionalTooltip::add);
                EnchantmentTooltipHelper.getEnchantingComponent(slotIndex + 1, player.field_7520, KEY_ONE_ENCHANTMENT_LEVEL, KEY_MANY_ENCHANTMENT_LEVELS).ifPresent(additionalTooltip::add);
            }
        }
        if (!additionalTooltip.isEmpty()) {
            if (!tooltipLines.isEmpty()) {
                tooltipLines.add(class_5244.field_39003);
            }
            tooltipLines.addAll(additionalTooltip);
        }
    }

    public static void gatherRerollTooltip(List<class_2561> tooltipLines, class_1657 player, ModEnchantmentMenu menu) {
        tooltipLines.add((class_2561)class_2561.method_43471((String)KEY_REROLL).method_27692(class_124.field_1080));
        ArrayList additionalTooltip = Lists.newArrayList();
        if (!player.method_31549().field_7477) {
            int rerollCatalystCost = ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollCatalystCost;
            if (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).dedicatedRerollCatalyst) {
                EnchantmentTooltipHelper.getEnchantingComponent(rerollCatalystCost, menu.getRerollCatalystCount(), KEY_ONE_REROLL_CATALYST, KEY_MANY_REROLL_CATALYSTS).ifPresent(additionalTooltip::add);
            } else {
                EnchantmentTooltipHelper.getEnchantingComponent(rerollCatalystCost, menu.getRerollCatalystCount(), KEY_ONE_ENCHANT_CATALYST, KEY_MANY_ENCHANT_CATALYSTS).ifPresent(additionalTooltip::add);
            }
            String singleKey = ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollingTakesEnchantmentLevels ? KEY_ONE_ENCHANTMENT_LEVEL : KEY_ONE_EXPERIENCE_POINT;
            String manyKey = ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollingTakesEnchantmentLevels ? KEY_MANY_ENCHANTMENT_LEVELS : KEY_MANY_EXPERIENCE_POINTS;
            EnchantmentTooltipHelper.getEnchantingComponent(((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollExperiencePointsCost, PlayerExperienceHelper.getTotalExperience(player), singleKey, manyKey).ifPresent(additionalTooltip::add);
        }
        if (!additionalTooltip.isEmpty()) {
            tooltipLines.add(class_5244.field_39003);
            tooltipLines.addAll(additionalTooltip);
        }
    }

    private static Optional<class_2561> getEnchantingComponent(int requiredAmount, int currentAmount, String singleKey, String manyKey) {
        if (requiredAmount < 1) {
            return Optional.empty();
        }
        class_5250 component = requiredAmount == 1 ? class_2561.method_43471((String)singleKey) : class_2561.method_43469((String)manyKey, (Object[])new Object[]{requiredAmount});
        return EnchantmentTooltipHelper.getEnchantingComponent(requiredAmount, currentAmount, component);
    }

    private static Optional<class_2561> getEnchantingComponent(int requiredAmount, int currentAmount, class_5250 component) {
        if (requiredAmount < 1) {
            return Optional.empty();
        }
        return Optional.of(component.method_27692(currentAmount >= requiredAmount ? class_124.field_1080 : class_124.field_1061));
    }
}

