/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easymagic.client.renderer.blockentity;

import fuzs.easymagic.EasyMagic;
import fuzs.easymagic.client.renderer.blockentity.state.ModEnchantTableRenderState;
import fuzs.easymagic.config.ClientConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11964;
import net.minecraft.class_12075;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2605;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_828;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class ModEnchantTableRenderer
extends class_828 {
    private final class_10442 itemModelResolver;

    public ModEnchantTableRenderer(class_5614.class_5615 context) {
        super(context);
        this.itemModelResolver = context.comp_4536();
    }

    public class_11964 method_74375() {
        return new ModEnchantTableRenderState();
    }

    public void method_74376(class_2605 blockEntity, class_11964 renderState, float partialTick, class_243 cameraPosition, @Nullable class_11683.class_11792 breakProgress) {
        super.method_74376(blockEntity, renderState, partialTick, cameraPosition, breakProgress);
        ((ModEnchantTableRenderState)renderState).items = new ArrayList<class_10444>();
        class_811 itemDisplayContext = this.getItemDisplayContext();
        if (itemDisplayContext != null) {
            List<class_1799> itemList = this.getItemList((class_1263)blockEntity);
            int position = (int)blockEntity.method_11016().method_10063();
            for (int i = 0; i < itemList.size(); ++i) {
                class_10444 itemStackRenderState = new class_10444();
                this.itemModelResolver.method_65598(itemStackRenderState, itemList.get(i), itemDisplayContext, blockEntity.method_10997(), null, position + i);
                ((ModEnchantTableRenderState)renderState).items.add(itemStackRenderState);
            }
        }
    }

    @Nullable
    private class_811 getItemDisplayContext() {
        return switch (((ClientConfig)EasyMagic.CONFIG.get(ClientConfig.class)).renderEnchantingTableContents) {
            case ClientConfig.ItemRenderType.FLOATING -> class_811.field_4318;
            case ClientConfig.ItemRenderType.FLAT -> class_811.field_4319;
            default -> null;
        };
    }

    private List<class_1799> getItemList(class_1263 container) {
        ArrayList<class_1799> itemStacks = new ArrayList<class_1799>();
        itemStacks.add(container.method_5438(0));
        for (int i = 0; i < 3; ++i) {
            if (i < container.method_5438(1).method_7947()) {
                itemStacks.add(container.method_5438(1));
            }
            if (i >= container.method_5438(2).method_7947()) continue;
            itemStacks.add(container.method_5438(2));
        }
        return itemStacks.stream().filter(Predicate.not(class_1799::method_7960)).map(itemStack -> itemStack.method_46651(1)).toList();
    }

    public void method_3571(class_11964 renderState, class_4587 poseStack, class_11659 nodeCollector, class_12075 cameraRenderState) {
        super.method_3571(renderState, poseStack, nodeCollector, cameraRenderState);
        switch (((ClientConfig)EasyMagic.CONFIG.get(ClientConfig.class)).renderEnchantingTableContents) {
            case FLAT: {
                this.submitFlatItemList((ModEnchantTableRenderState)renderState, poseStack, nodeCollector);
                break;
            }
            case FLOATING: {
                this.submitFloatingItemStack((ModEnchantTableRenderState)renderState, poseStack, nodeCollector);
                this.submitFloatingItemList((ModEnchantTableRenderState)renderState, poseStack, nodeCollector);
            }
        }
    }

    private void submitFlatItemList(ModEnchantTableRenderState renderState, class_4587 poseStack, class_11659 nodeCollector) {
        int position = Math.abs(renderState.field_62673.method_10263() + renderState.field_62673.method_10260()) % 4;
        int j = 0;
        for (int i = 0; i < renderState.items.size() && j < 4; ++i) {
            class_10444 itemStackRenderState = renderState.items.get(i);
            if (itemStackRenderState.method_65606()) continue;
            poseStack.method_22903();
            poseStack.method_22904(0.5, 0.76171875, 0.5);
            class_2350 direction = class_2350.method_10139((int)((j + position) % 4));
            float horizontalAngle = -direction.method_10144();
            poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(horizontalAngle));
            poseStack.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(90.0f));
            poseStack.method_22904(-0.3125, -0.3125, 0.0);
            poseStack.method_22905(0.375f, 0.375f, 0.375f);
            itemStackRenderState.method_65604(poseStack, nodeCollector, renderState.field_62676, class_4608.field_21444, 0);
            poseStack.method_22909();
            ++j;
        }
    }

    private void submitFloatingItemStack(ModEnchantTableRenderState renderState, class_4587 poseStack, class_11659 nodeCollector) {
        if (renderState.field_62721 > 0.0f && !renderState.items.isEmpty() && !renderState.items.getFirst().method_65606()) {
            poseStack.method_22903();
            poseStack.method_46416(0.5f, 1.0f, 0.5f);
            float hoverOffset = class_3532.method_15374((float)(renderState.field_62718 / 10.0f)) * 0.1f + 0.1f;
            class_238 aABB = renderState.items.getFirst().method_72173();
            float modelYScale = -((float)aABB.field_1322) + 0.0625f;
            float openness = renderState.field_62721;
            poseStack.method_22904(0.0, (double)(hoverOffset + modelYScale * openness - 0.15f * (1.0f - openness)), 0.0);
            float scale = openness * 0.8f + 0.2f;
            poseStack.method_22905(scale, scale, scale);
            poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotation(renderState.field_62718 / 20.0f));
            renderState.items.getFirst().method_65604(poseStack, nodeCollector, renderState.field_62676, class_4608.field_21444, 0);
            poseStack.method_22909();
        }
    }

    private void submitFloatingItemList(ModEnchantTableRenderState renderState, class_4587 poseStack, class_11659 nodeCollector) {
        this.submitFloatingItemList(renderState, poseStack, nodeCollector, true);
    }

    private void submitFloatingItemList(ModEnchantTableRenderState renderState, class_4587 poseStack, class_11659 nodeCollector, boolean rotateItems) {
        if (!renderState.items.isEmpty()) {
            int nonEmptyItems = (int)renderState.items.subList(1, renderState.items.size()).stream().filter(Predicate.not(class_10444::method_65606)).count();
            float angle = 360.0f / (float)nonEmptyItems;
            int j = 0;
            for (int i = 1; i < renderState.items.size(); ++i) {
                class_10444 itemStackRenderState = renderState.items.get(i);
                if (itemStackRenderState.method_65606()) continue;
                poseStack.method_22903();
                poseStack.method_46416(0.5f, 1.0f, 0.5f);
                poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees((float)j * angle + renderState.field_62718));
                poseStack.method_46416(0.75f, 0.0f, 0.25f);
                poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(rotateItems ? renderState.field_62718 % 360.0f : 90.0f));
                poseStack.method_22904(0.0, 0.075 * Math.sin(((double)renderState.field_62718 + (double)j * 10.0) / 5.0), 0.0);
                itemStackRenderState.method_65604(poseStack, nodeCollector, renderState.field_62676, class_4608.field_21444, 0);
                poseStack.method_22909();
                ++j;
            }
        }
    }
}

