/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easymagic.client;

import fuzs.easymagic.EasyMagic;
import fuzs.easymagic.client.gui.screens.inventory.ModEnchantmentScreen;
import fuzs.easymagic.client.handler.BlockStateTranslator;
import fuzs.easymagic.client.handler.ChiseledBookshelfTooltipHandler;
import fuzs.easymagic.client.renderer.blockentity.ModEnchantTableRenderer;
import fuzs.easymagic.handler.BlockConversionHandler;
import fuzs.easymagic.init.ModRegistry;
import fuzs.puzzleslib.api.client.core.v1.ClientModConstructor;
import fuzs.puzzleslib.api.client.core.v1.context.BlockEntityRenderersContext;
import fuzs.puzzleslib.api.client.core.v1.context.BlockStateResolverContext;
import fuzs.puzzleslib.api.client.core.v1.context.GuiLayersContext;
import fuzs.puzzleslib.api.client.core.v1.context.MenuScreensContext;
import fuzs.puzzleslib.api.client.core.v1.context.RenderTypesContext;
import fuzs.puzzleslib.api.client.event.v1.gui.RenderTooltipCallback;
import fuzs.puzzleslib.api.client.renderer.v1.model.ModelLoadingHelper;
import java.util.Map;
import java.util.concurrent.Executor;
import net.minecraft.class_1087;
import net.minecraft.class_2248;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3300;
import net.minecraft.class_3917;

public class EasyMagicClient
implements ClientModConstructor {
    public void onConstructMod() {
        EasyMagicClient.registerEventHandlers();
    }

    private static void registerEventHandlers() {
        RenderTooltipCallback.EVENT.register(ModEnchantmentScreen::onRenderTooltip);
    }

    public void onRegisterBlockStateResolver(BlockStateResolverContext context) {
        BlockConversionHandler.getBlockConversions().forEach((oldBlock, newBlock) -> context.registerBlockStateResolver(newBlock, (resourceManager, executor) -> ModelLoadingHelper.loadBlockState((class_3300)resourceManager, (class_2248)oldBlock, (Executor)executor), (loadedModels, blockStateConsumer) -> {
            Map<class_2680, class_2680> blockStates = BlockStateTranslator.INSTANCE.convertAllBlockStates((class_2248)newBlock, (class_2248)oldBlock);
            for (class_2680 blockState : newBlock.method_9595().method_11662()) {
                class_1087.class_9979 model = (class_1087.class_9979)loadedModels.comp_3063().get(blockStates.get(blockState));
                if (model != null) {
                    blockStateConsumer.accept(blockState, model);
                    continue;
                }
                EasyMagic.LOGGER.warn("Missing model for variant: '{}'", (Object)blockState);
                blockStateConsumer.accept(blockState, ModelLoadingHelper.missingModel());
            }
        }));
    }

    public void onRegisterMenuScreens(MenuScreensContext context) {
        context.registerMenuScreen((class_3917)ModRegistry.ENCHANTING_MENU_TYPE.comp_349(), ModEnchantmentScreen::new);
    }

    public void onRegisterBlockEntityRenderers(BlockEntityRenderersContext context) {
        context.registerBlockEntityRenderer((class_2591)ModRegistry.ENCHANTING_TABLE_BLOCK_ENTITY_TYPE.comp_349(), ModEnchantTableRenderer::new);
    }

    public void onRegisterBlockRenderTypes(RenderTypesContext<class_2248> context) {
        for (Map.Entry entry : BlockConversionHandler.getBlockConversions().entrySet()) {
            context.registerChunkRenderType((Object)((class_2248)entry.getValue()), context.getChunkRenderType((Object)((class_2248)entry.getKey())));
        }
    }

    public void onRegisterGuiLayers(GuiLayersContext context) {
        context.registerGuiLayer(GuiLayersContext.HELD_ITEM_TOOLTIP, EasyMagic.id("chiseled_bookshelf_tooltip"), ChiseledBookshelfTooltipHandler::render);
    }
}

