/*
 * Decompiled with CFR 0.152.
 */
package dev.kikugie.elytratrims.api.render;

import dev.kikugie.elytratrims.api.impl.ETRenderingAPIImpl;
import dev.kikugie.elytratrims.api.impl.ETRenderingAPIUtilsKt;
import dev.kikugie.elytratrims.api.render.ETDecorator;
import dev.kikugie.elytratrims.api.render.ETRenderParameters;
import dev.kikugie.elytratrims.api.render.ETRendererID;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import kotlin.sequences.SequencesKt;
import net.minecraft.class_11659;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.NonExtendable
public interface ETRenderingAPI {
    @NotNull
    public static List<ETDecorator> registeredDecorators() {
        return SequencesKt.toList(ETRenderingAPIImpl.getDecorators());
    }

    @NotNull
    public static ETRendererID registerDecorator(@NotNull ETDecorator instance) {
        return ETRenderingAPIImpl.registerDecorator(instance, List::addLast);
    }

    @NotNull
    public static ETRendererID registerDecoratorBefore(@NotNull ETDecorator instance, @NotNull class_2960 before) {
        return ETRenderingAPIImpl.registerDecorator(instance, (list, it) -> {
            int index = ETRenderingAPIUtilsKt.indexOfId(list, before);
            if (index < 0) {
                throw new IllegalStateException("Decorator %s is not registered yet".formatted(before));
            }
            list.add(index, it);
        });
    }

    @NotNull
    public static ETRendererID registerDecoratorAfter(@NotNull ETDecorator instance, @NotNull class_2960 after) {
        return ETRenderingAPIImpl.registerDecorator(instance, (list, it) -> {
            int index = ETRenderingAPIUtilsKt.indexOfId(list, after);
            if (index < 0) {
                throw new IllegalStateException("Decorator %s is not registered yet".formatted(after));
            }
            if (index == list.size() - 1) {
                list.addLast(it);
            } else {
                list.add(index + 1, it);
            }
        });
    }

    public static void wrapRenderParameters(@NotNull UnaryOperator<ETRenderParameters> parameters) {
        for (ETDecorator renderer : ETRenderingAPI.registeredDecorators()) {
            ETRenderingAPI.wrapRenderParameters(renderer.getType(), parameters);
        }
    }

    public static void wrapRenderParameters(@NotNull ETRendererID type, @NotNull UnaryOperator<ETRenderParameters> parameters) {
        ETRenderingAPIImpl.wrapRenderParameters(type, parameters);
    }

    public static void wrapRenderCall(@NotNull Callback callback) {
        for (ETDecorator renderer : ETRenderingAPI.registeredDecorators()) {
            ETRenderingAPI.wrapRenderCall(renderer.getType(), callback);
        }
    }

    public static void wrapRenderCall(@NotNull ETRendererID type, @NotNull Callback callback) {
        ETRenderingAPIImpl.wrapRenderCall(type, callback);
    }

    @FunctionalInterface
    public static interface Callback {
        public boolean render(@NotNull ETRenderParameters var1, @NotNull class_11659 var2, @NotNull BiFunction<ETRenderParameters, class_11659, Boolean> var3);
    }
}

