/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.villagernames_common_forge.events;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_forge.functions.EntityFunctions;
import com.natamus.villagernames_common_forge.config.ConfigHandler;
import com.natamus.villagernames_common_forge.data.Variables;
import com.natamus.villagernames_common_forge.util.Names;
import com.natamus.villagernames_common_forge.util.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;

public class VillagerEvent {
    public static void onSpawn(Level level, Entity entity) {
        if (level.isClientSide()) {
            return;
        }
        if (entity.getTags().contains("villagernames.named")) {
            return;
        }
        if (!(entity instanceof Villager)) {
            boolean goname = false;
            if (ConfigHandler.nameModdedVillagers && EntityFunctions.isModdedVillager((Entity)entity)) {
                goname = true;
            }
            if (!goname) {
                return;
            }
        }
        if (entity.hasCustomName() && !Util.shouldOverwriteName(entity)) {
            return;
        }
        String name = Names.getRandomName();
        if (!name.equals("")) {
            EntityFunctions.nameEntity((Entity)entity, (String)name);
            entity.getTags().add("villagernames.named");
        }
    }

    public static InteractionResult onVillagerInteract(Player player, Level level, InteractionHand hand, Entity entity, EntityHitResult hitResult) {
        MutableComponent profession;
        String translatableInput;
        if (!level.isClientSide()) {
            return InteractionResult.PASS;
        }
        if (!entity.getClass().equals(Villager.class)) {
            return InteractionResult.PASS;
        }
        if (!entity.hasCustomName()) {
            return InteractionResult.PASS;
        }
        if (player.isCrouching()) {
            return InteractionResult.PASS;
        }
        if (!hand.equals((Object)InteractionHand.MAIN_HAND)) {
            return InteractionResult.PASS;
        }
        Villager villager = (Villager)entity;
        VillagerData d = villager.getVillagerData();
        String rawProfession = d.profession().getRegisteredName();
        if (rawProfession.equals("none") || rawProfession.equals("nitwit")) {
            return InteractionResult.PASS;
        }
        if (rawProfession.contains(":")) {
            rawProfession = rawProfession.split(":")[1];
        }
        if (rawProfession.contains("-")) {
            rawProfession = rawProfession.split("-")[0];
        }
        if ((translatableInput = "entity.minecraft.villager." + rawProfession.trim()).equals((profession = Component.translatable((String)translatableInput)).getString())) {
            profession = Component.literal((String)(rawProfession.substring(0, 1).toUpperCase() + rawProfession.substring(1)));
        }
        Variables.tradedVillagerPair = new Pair((Object)villager.getName(), (Object)profession);
        return InteractionResult.PASS;
    }
}

