/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.flow;

import java.util.Iterator;
import java.util.List;
import team.creative.creativecore.client.gui.GuiControlRect;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.VAlign;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.util.math.Maths;
import team.creative.creativecore.common.util.type.list.MarkList;

public class GuiStackX
extends GuiFlow {
    @Override
    public int minWidth(List<? extends GuiControlRect> controls, int spacing, int availableWidth) {
        boolean has = false;
        int width = -spacing;
        for (GuiControlRect guiControlRect : controls) {
            int min = guiControlRect.getMinWidth(availableWidth);
            if (min != -1) {
                width += min;
                has = true;
            }
            width += spacing;
        }
        return has ? width : -1;
    }

    @Override
    public int preferredWidth(List<? extends GuiControlRect> controls, int spacing, int availableWidth) {
        int width = -spacing;
        for (GuiControlRect guiControlRect : controls) {
            width += guiControlRect.getPreferredWidth(availableWidth) + spacing;
        }
        return width;
    }

    @Override
    public int minHeight(List<? extends GuiControlRect> controls, int spacing, int width, int availableHeight) {
        int height = -1;
        for (GuiControlRect guiControlRect : controls) {
            height = Math.max(height, guiControlRect.getMinHeight(availableHeight));
        }
        return height;
    }

    @Override
    public int preferredHeight(List<? extends GuiControlRect> controls, int spacing, int width, int availableHeight) {
        int height = 0;
        for (GuiControlRect guiControlRect : controls) {
            height = Math.max(height, guiControlRect.getPreferredHeight(availableHeight));
        }
        return height;
    }

    @Override
    public void flowX(List<? extends GuiControlRect> controls, int spacing, Align align, int width, int preferred, boolean endless) {
        block30: {
            int available;
            block31: {
                block29: {
                    available = width - spacing * (controls.size() - 1);
                    MarkList<? extends GuiControlRect> list = new MarkList<GuiControlRect>(controls);
                    if (width >= preferred) {
                        if (align == Align.STRETCH && !GuiStackX.areChildrenExpandableX(controls)) {
                            for (GuiControlRect guiControlRect : list) {
                                int n = guiControlRect.getMinWidth(width);
                                if (n != -1) {
                                    available -= n;
                                    guiControlRect.setWidth(n, width);
                                    continue;
                                }
                                guiControlRect.setWidth(0, width);
                            }
                            while (available > 0 && !list.isEmpty()) {
                                int average = (int)Math.ceil((double)available / (double)list.remaing());
                                Iterator iterator = list.iterator();
                                while (iterator.hasNext()) {
                                    GuiControlRect guiControlRect = (GuiControlRect)iterator.next();
                                    int toAdd = Maths.min(average, available, guiControlRect.getPreferredWidth(width) - guiControlRect.getWidth());
                                    if (toAdd <= 0) {
                                        iterator.mark();
                                        continue;
                                    }
                                    available -= guiControlRect.addWidth(toAdd, width);
                                    if (!guiControlRect.isMaxWidth(width)) continue;
                                    iterator.mark();
                                }
                            }
                            list.clear();
                            while (available > 0 && !list.isEmpty()) {
                                int average = (int)Math.ceil((double)available / (double)list.remaing());
                                Iterator iterator = list.iterator();
                                while (iterator.hasNext()) {
                                    GuiControlRect guiControlRect = (GuiControlRect)iterator.next();
                                    available -= guiControlRect.addWidth(Math.min(average, available), width);
                                    if (!guiControlRect.isMaxWidth(width)) continue;
                                    iterator.mark();
                                }
                            }
                        } else {
                            Iterator itr = list.iterator();
                            while (itr.hasNext()) {
                                GuiControlRect guiControlRect = (GuiControlRect)itr.next();
                                guiControlRect.setWidth(guiControlRect.getPreferredWidth(width), width);
                                if (!guiControlRect.isExpandableX()) {
                                    itr.mark();
                                }
                                available -= guiControlRect.getWidth();
                            }
                            if (align == Align.STRETCH || GuiStackX.areChildrenExpandableX(controls)) {
                                while (available > 0 && !list.isEmpty()) {
                                    int average = (int)Math.ceil((double)available / (double)list.remaing());
                                    Iterator iterator = list.iterator();
                                    while (iterator.hasNext()) {
                                        GuiControlRect guiControlRect = (GuiControlRect)iterator.next();
                                        available -= guiControlRect.addWidth(Math.min(average, available), width);
                                        if (!guiControlRect.isMaxWidth(width)) continue;
                                        iterator.mark();
                                    }
                                }
                            }
                        }
                    } else if (endless) {
                        for (GuiControlRect guiControlRect : controls) {
                            guiControlRect.setWidth(guiControlRect.getPreferredWidth(width), width);
                        }
                        align = Align.LEFT;
                    } else {
                        for (GuiControlRect guiControlRect : list) {
                            int n = guiControlRect.getMinWidth(width);
                            if (n != -1) {
                                available -= n;
                                guiControlRect.setWidth(n, width);
                                continue;
                            }
                            guiControlRect.setWidth(0, width);
                        }
                        while (available > 0 && !list.isEmpty()) {
                            int average = (int)Math.ceil((double)available / (double)list.remaing());
                            Iterator iterator = list.iterator();
                            while (iterator.hasNext()) {
                                GuiControlRect guiControlRect = (GuiControlRect)iterator.next();
                                int prefer = guiControlRect.getPreferredWidth(width);
                                available -= guiControlRect.addWidth(Math.min(average, Math.min(prefer - guiControlRect.getWidth(), available)), width);
                                if (!guiControlRect.isMaxWidth(width) && prefer > guiControlRect.getWidth()) continue;
                                iterator.mark();
                            }
                        }
                        list.clear();
                        while (available > 0 && !list.isEmpty()) {
                            int average = (int)Math.ceil((double)available / (double)list.remaing());
                            Iterator iterator = list.iterator();
                            while (iterator.hasNext()) {
                                GuiControlRect guiControlRect = (GuiControlRect)iterator.next();
                                available -= guiControlRect.addWidth(Math.min(average, available), width);
                                if (!guiControlRect.isMaxWidth(width)) continue;
                                iterator.mark();
                            }
                        }
                    }
                    for (GuiControlRect guiControlRect : controls) {
                        guiControlRect.flowX();
                    }
                    if (available > 0 && align != Align.LEFT) break block29;
                    int x = 0;
                    for (GuiControlRect guiControlRect : controls) {
                        guiControlRect.setX(x);
                        x += guiControlRect.getWidth() + spacing;
                    }
                    break block30;
                }
                if (align != Align.RIGHT) break block31;
                int x = width;
                for (GuiControlRect guiControlRect : controls) {
                    guiControlRect.setX(x -= guiControlRect.getWidth());
                    x -= spacing;
                }
                break block30;
            }
            if (align != Align.CENTER && align != Align.STRETCH) break block30;
            int x = available / 2;
            for (GuiControlRect guiControlRect : controls) {
                guiControlRect.setX(x);
                x += guiControlRect.getWidth() + spacing;
            }
        }
    }

    @Override
    public void flowY(List<? extends GuiControlRect> controls, int spacing, VAlign valign, int width, int height, int preferred, boolean endless) {
        int maxHeight = height;
        if (endless && preferred > height) {
            maxHeight = preferred;
        }
        boolean expandable = GuiStackX.areChildrenExpandableY(controls);
        if (valign == VAlign.TOP && !expandable) {
            for (GuiControlRect guiControlRect : controls) {
                guiControlRect.setY(0);
                guiControlRect.setHeight(Math.min(maxHeight, guiControlRect.getPreferredHeight(height)), height);
                guiControlRect.flowY();
            }
        } else if (valign == VAlign.STRETCH || expandable) {
            for (GuiControlRect guiControlRect : controls) {
                if (guiControlRect.isExpandableY() || valign == VAlign.STRETCH) {
                    guiControlRect.setHeight(maxHeight, height);
                } else {
                    guiControlRect.setHeight(Math.min(maxHeight, guiControlRect.getPreferredHeight(height)), height);
                }
                guiControlRect.setY(0);
                guiControlRect.flowY();
            }
        } else if (valign == VAlign.BOTTOM) {
            for (GuiControlRect guiControlRect : controls) {
                guiControlRect.setHeight(Math.min(maxHeight, guiControlRect.getPreferredHeight(height)), height);
                guiControlRect.setY(maxHeight - guiControlRect.getHeight());
                guiControlRect.flowY();
            }
        } else {
            for (GuiControlRect guiControlRect : controls) {
                guiControlRect.setHeight(Math.min(maxHeight, guiControlRect.getPreferredHeight(height)), height);
                guiControlRect.setY((int)Math.ceil((double)maxHeight / 2.0 - (double)guiControlRect.getHeight() / 2.0));
                guiControlRect.flowY();
            }
        }
    }
}

