/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.config.gui;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import team.creative.creativecore.Side;
import team.creative.creativecore.common.config.gui.GuiConfigControl;
import team.creative.creativecore.common.config.gui.GuiConfigSubControl;
import team.creative.creativecore.common.config.holder.ICreativeConfigHolder;
import team.creative.creativecore.common.config.key.ConfigKey;
import team.creative.creativecore.common.config.key.ConfigKeyType;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.IGuiParent;
import team.creative.creativecore.common.gui.flow.GuiFlow;

public class GuiConfigSubControlHolder
extends GuiConfigSubControl {
    public ICreativeConfigHolder holder;
    public Object value;
    private final Runnable updateListener;
    private final Side side;

    public GuiConfigSubControlHolder(IGuiParent parent, String name, ICreativeConfigHolder holder, Object value, Side side, @Nullable Runnable updateListener) {
        super(parent, name);
        this.setExpandable();
        this.holder = holder;
        this.value = value;
        this.side = side;
        this.updateListener = updateListener;
        this.setFlow(GuiFlow.STACK_Y);
    }

    public void load(ICreativeConfigHolder holder, Object value) {
        this.holder = holder;
        this.value = value;
    }

    public void createControls() {
        for (ConfigKey configKey : this.holder.fields()) {
            if (configKey.requiresRestart || configKey.isFolder() || configKey.hideFromGUI) continue;
            String path = "config." + String.join((CharSequence)".", this.holder.path());
            if (!path.endsWith(".")) {
                path = path + ".";
            }
            String caption = GuiConfigSubControlHolder.translateOrDefault(path + configKey.name + ".name", configKey.name);
            String comment = path + configKey.name + ".comment";
            GuiConfigControl config = new GuiConfigControl(this, (ConfigKeyType)configKey, this.side, caption, comment){

                @Override
                public void updateButton() {
                    super.updateButton();
                    if (GuiConfigSubControlHolder.this.updateListener != null) {
                        GuiConfigSubControlHolder.this.updateListener.run();
                    }
                }
            };
            this.add((GuiControl)config);
            config.init(null);
        }
    }

    public void save() {
        JsonObject json = new JsonObject();
        for (GuiControl control : this) {
            GuiConfigControl c;
            JsonElement element;
            if (!(control instanceof GuiConfigControl) || (element = (c = (GuiConfigControl)control).save()) == null) continue;
            json.add(c.field.name, element);
        }
        this.holder.load(this.provider(), false, true, json, this.side);
    }
}

