/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.config.gui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.class_2561;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.Side;
import team.creative.creativecore.common.config.holder.ICreativeConfigHolder;
import team.creative.creativecore.common.config.key.ConfigKey;
import team.creative.creativecore.common.config.sync.ConfigurationClientPacket;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.IGuiParent;
import team.creative.creativecore.common.gui.VAlign;
import team.creative.creativecore.common.gui.control.parent.GuiColumn;
import team.creative.creativecore.common.gui.control.parent.GuiLeftRightBox;
import team.creative.creativecore.common.gui.control.parent.GuiRow;
import team.creative.creativecore.common.gui.control.parent.GuiScrollY;
import team.creative.creativecore.common.gui.control.simple.GuiButton;
import team.creative.creativecore.common.gui.control.simple.GuiCheckBox;
import team.creative.creativecore.common.gui.control.simple.GuiLabel;
import team.creative.creativecore.common.gui.dialog.DialogGuiLayer;
import team.creative.creativecore.common.gui.dialog.GuiDialogHandler;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.util.text.TextBuilder;
import team.creative.creativecore.common.util.type.tree.CheckTree;

public class ClientSyncGuiLayer
extends GuiLayer {
    public final CheckTree<ConfigKey> tree;
    public final ICreativeConfigHolder root;
    public CheckTree.CheckTreeEntry currentView;
    public boolean changed = false;
    public int nextAction;
    public boolean force;

    public ClientSyncGuiLayer(boolean client, ICreativeConfigHolder holder) {
        super(client, "client-sync", 300, 200);
        this.root = holder;
        this.setFlow(GuiFlow.STACK_Y);
        this.registerEvent(GuiControlChangedEvent.class, x -> {
            this.changed = true;
            if (x.control instanceof GuiTreeCheckBox && !((GuiTreeCheckBox)x.control).get()) {
                ((GuiTreeCheckBox)x.control).setPartial(((GuiTreeCheckBox)x.control).entry.isChildEnabled());
            }
        });
        BiConsumer<ConfigKey, Boolean> setter = (x, y) -> {
            x.forceSynchronization = y;
        };
        Function<ConfigKey, Boolean> getter = x -> x.forceSynchronization;
        Function<ConfigKey, Collection> getChildren = x -> {
            if (x.isFolder()) {
                ArrayList<ConfigKey> keys = new ArrayList<ConfigKey>();
                for (ConfigKey configKey : x.holder().fields()) {
                    if (!configKey.isWithoutForce(Side.CLIENT) || configKey.isFolder() && configKey.holder().isEmptyWithoutForce(Side.CLIENT)) continue;
                    keys.add(configKey);
                }
                return keys;
            }
            return null;
        };
        ArrayList<ConfigKey> keys = new ArrayList<ConfigKey>();
        for (ConfigKey configKey : holder.fields()) {
            if (!configKey.isWithoutForce(Side.CLIENT) || configKey.isFolder() && configKey.holder().isEmptyWithoutForce(Side.CLIENT)) continue;
            keys.add(configKey);
        }
        this.tree = new CheckTree<ConfigKey>(keys, setter, getter, getChildren);
        this.currentView = this.tree.root;
    }

    @Override
    public void create() {
        this.load(this.currentView);
    }

    public void save() {
        this.getIntegratedParent().send(new ConfigurationClientPacket(this.root, this.tree));
    }

    public void load(CheckTree.CheckTreeEntry entry) {
        if (!this.isEmpty()) {
            this.clear();
        }
        ICreativeConfigHolder holder = entry.content == null ? this.root : ((ConfigKey)entry.content).holder();
        this.add((GuiControl)new GuiLeftRightBox(this).addLeft(new GuiLabel(this, "path").setTitle((class_2561)class_2561.method_43470((String)("/" + String.join((CharSequence)"/", holder.path()))))).addRight(new GuiButton(this, "back", x -> this.load(entry.parent)).setTranslate("gui.back").setEnabled(entry.parent != null)));
        this.currentView = entry;
        GuiScrollY box = new GuiScrollY((IGuiParent)this, "").setExpandable().setDim(100, 100);
        this.add((GuiControl)box);
        for (CheckTree.CheckTreeEntry key : this.currentView.children) {
            GuiRow row = new GuiRow(this);
            box.add((GuiControl)row);
            GuiColumn first = new GuiColumn((IGuiParent)this, 20);
            row.addColumn(first);
            first.setVAlign(VAlign.CENTER);
            first.setAlign(Align.CENTER);
            first.add((GuiControl)new GuiTreeCheckBox((IGuiParent)this, key));
            GuiColumn second = (GuiColumn)new GuiColumn(this).setExpandableX();
            row.addColumn(second);
            String caption = ClientSyncGuiLayer.translateOrDefault("config." + String.join((CharSequence)".", holder.path()) + "." + ((ConfigKey)key.content).name + ".name", ((ConfigKey)key.content).name);
            String comment = "config." + String.join((CharSequence)".", holder.path()) + "." + ((ConfigKey)key.content).name + ".comment";
            if (((ConfigKey)key.content).isFolder()) {
                second.add(new GuiButton(this, caption, x -> this.load(key)).setTitle((class_2561)class_2561.method_43470((String)caption)).setTooltip(new TextBuilder().translateIfCan(comment).build()));
                continue;
            }
            second.add(new GuiLabel(this, caption).setTitle((class_2561)class_2561.method_43470((String)caption)).setTooltip(new TextBuilder().translateIfCan(comment).build()));
        }
        this.add((GuiControl)new GuiLeftRightBox(this).addLeft(new GuiButton(this, "cancel", x -> {
            this.nextAction = 0;
            this.closeTopLayer();
        }).setTranslate("gui.cancel")).addLeft(new GuiButton(this, "config", x -> {
            this.nextAction = 1;
            this.closeTopLayer();
        }).setTranslate("gui.config")).addRight(new GuiButton(this, "save", x -> {
            this.nextAction = 0;
            this.force = true;
            this.save();
            this.closeTopLayer();
        }).setTitle((class_2561)class_2561.method_43471((String)"gui.save"))));
        this.reinit();
    }

    @Override
    public void closeTopLayer() {
        if (this.force || !this.changed) {
            if (this.nextAction == 0) {
                super.closeTopLayer();
            } else if (this.nextAction == 1) {
                CreativeCore.CONFIG_OPEN.open(this.getPlayer());
            }
        } else {
            GuiDialogHandler.openDialog(this.getIntegratedParent(), "savechanges", (x, y) -> {
                if (y == DialogGuiLayer.DialogButton.YES) {
                    this.save();
                }
                if (y != DialogGuiLayer.DialogButton.CANCEL) {
                    this.force = true;
                    this.closeTopLayer();
                }
            }, DialogGuiLayer.DialogButton.YES, DialogGuiLayer.DialogButton.NO, DialogGuiLayer.DialogButton.CANCEL);
        }
    }

    public static class GuiTreeCheckBox
    extends GuiCheckBox {
        public final CheckTree.CheckTreeEntry entry;

        public GuiTreeCheckBox(IGuiParent parent, CheckTree.CheckTreeEntry entry) {
            super(parent, ((ConfigKey)entry.content).name, entry.isEnabled());
            this.entry = entry;
            if (!this.get()) {
                this.setPartial(entry.isChildEnabled());
            }
        }
    }
}

