/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.gui.registry;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import team.creative.creativecore.client.config.gui.GuiClientTreeCheckBox;
import team.creative.creativecore.client.gui.GuiClientControl;
import team.creative.creativecore.client.gui.GuiClientLayer;
import team.creative.creativecore.client.gui.GuiClientParent;
import team.creative.creativecore.client.gui.control.collection.GuiClientCheckList;
import team.creative.creativecore.client.gui.control.collection.GuiClientComboBox;
import team.creative.creativecore.client.gui.control.collection.GuiClientComboBoxExtension;
import team.creative.creativecore.client.gui.control.collection.GuiClientComboBoxFlexible;
import team.creative.creativecore.client.gui.control.collection.GuiClientComboBoxTree;
import team.creative.creativecore.client.gui.control.collection.GuiClientListBoxBase;
import team.creative.creativecore.client.gui.control.collection.GuiClientStackSelector;
import team.creative.creativecore.client.gui.control.collection.GuiClientStackSelectorExtension;
import team.creative.creativecore.client.gui.control.inventory.GuiClientInventoryGrid;
import team.creative.creativecore.client.gui.control.inventory.GuiClientInventoryGridPreview;
import team.creative.creativecore.client.gui.control.inventory.GuiClientSlot;
import team.creative.creativecore.client.gui.control.inventory.GuiClientSlotViewer;
import team.creative.creativecore.client.gui.control.menu.GuiClientMenu;
import team.creative.creativecore.client.gui.control.menu.GuiClientMenuRoot;
import team.creative.creativecore.client.gui.control.menu.GuiClientMenuSub;
import team.creative.creativecore.client.gui.control.parent.GuiClientPanel;
import team.creative.creativecore.client.gui.control.parent.GuiClientScrollX;
import team.creative.creativecore.client.gui.control.parent.GuiClientScrollXY;
import team.creative.creativecore.client.gui.control.parent.GuiClientScrollY;
import team.creative.creativecore.client.gui.control.parent.GuiClientTable;
import team.creative.creativecore.client.gui.control.parent.GuiClientTableScrollable;
import team.creative.creativecore.client.gui.control.parent.GuiClientTabs;
import team.creative.creativecore.client.gui.control.simple.GuiClientArraySlider;
import team.creative.creativecore.client.gui.control.simple.GuiClientButton;
import team.creative.creativecore.client.gui.control.simple.GuiClientButtonContext;
import team.creative.creativecore.client.gui.control.simple.GuiClientButtonHold;
import team.creative.creativecore.client.gui.control.simple.GuiClientButtonIcon;
import team.creative.creativecore.client.gui.control.simple.GuiClientCheckBox;
import team.creative.creativecore.client.gui.control.simple.GuiClientCheckButtonIcon;
import team.creative.creativecore.client.gui.control.simple.GuiClientColorPlate;
import team.creative.creativecore.client.gui.control.simple.GuiClientColoredSteppedSlider;
import team.creative.creativecore.client.gui.control.simple.GuiClientIcon;
import team.creative.creativecore.client.gui.control.simple.GuiClientLabel;
import team.creative.creativecore.client.gui.control.simple.GuiClientLabelHover;
import team.creative.creativecore.client.gui.control.simple.GuiClientListEntry;
import team.creative.creativecore.client.gui.control.simple.GuiClientProgressbar;
import team.creative.creativecore.client.gui.control.simple.GuiClientSeekBar;
import team.creative.creativecore.client.gui.control.simple.GuiClientShowItem;
import team.creative.creativecore.client.gui.control.simple.GuiClientSlider;
import team.creative.creativecore.client.gui.control.simple.GuiClientStateButton;
import team.creative.creativecore.client.gui.control.simple.GuiClientStateButtonIcon;
import team.creative.creativecore.client.gui.control.simple.GuiClientSteppedSlider;
import team.creative.creativecore.client.gui.control.simple.GuiClientTabButton;
import team.creative.creativecore.client.gui.control.simple.GuiClientTextfield;
import team.creative.creativecore.client.gui.control.timeline.GuiClientTimeline;
import team.creative.creativecore.client.gui.control.timeline.GuiClientTimelineChannel;
import team.creative.creativecore.client.gui.control.timeline.GuiClientTimelineHeader;
import team.creative.creativecore.client.gui.control.timeline.GuiClientTimelineKey;
import team.creative.creativecore.client.gui.control.tree.GuiClientTree;
import team.creative.creativecore.client.gui.control.tree.GuiClientTreeItem;
import team.creative.creativecore.client.gui.manager.GuiClientManager;
import team.creative.creativecore.client.gui.manager.GuiClientManagerItem;
import team.creative.creativecore.common.config.gui.ClientSyncGuiLayer;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.control.collection.GuiCheckList;
import team.creative.creativecore.common.gui.control.collection.GuiComboBox;
import team.creative.creativecore.common.gui.control.collection.GuiComboBoxExtension;
import team.creative.creativecore.common.gui.control.collection.GuiComboBoxFlexible;
import team.creative.creativecore.common.gui.control.collection.GuiComboBoxTree;
import team.creative.creativecore.common.gui.control.collection.GuiListBoxBase;
import team.creative.creativecore.common.gui.control.collection.GuiStackSelector;
import team.creative.creativecore.common.gui.control.collection.GuiStackSelectorExtension;
import team.creative.creativecore.common.gui.control.inventory.GuiInventoryGrid;
import team.creative.creativecore.common.gui.control.inventory.GuiInventoryGridPreview;
import team.creative.creativecore.common.gui.control.inventory.GuiSlot;
import team.creative.creativecore.common.gui.control.inventory.GuiSlotViewer;
import team.creative.creativecore.common.gui.control.menu.GuiMenu;
import team.creative.creativecore.common.gui.control.menu.GuiMenuRoot;
import team.creative.creativecore.common.gui.control.menu.GuiMenuSub;
import team.creative.creativecore.common.gui.control.parent.GuiPanel;
import team.creative.creativecore.common.gui.control.parent.GuiScrollX;
import team.creative.creativecore.common.gui.control.parent.GuiScrollXY;
import team.creative.creativecore.common.gui.control.parent.GuiScrollY;
import team.creative.creativecore.common.gui.control.parent.GuiTable;
import team.creative.creativecore.common.gui.control.parent.GuiTableScrollable;
import team.creative.creativecore.common.gui.control.parent.GuiTabs;
import team.creative.creativecore.common.gui.control.simple.GuiArraySlider;
import team.creative.creativecore.common.gui.control.simple.GuiButton;
import team.creative.creativecore.common.gui.control.simple.GuiButtonContext;
import team.creative.creativecore.common.gui.control.simple.GuiButtonHold;
import team.creative.creativecore.common.gui.control.simple.GuiButtonIcon;
import team.creative.creativecore.common.gui.control.simple.GuiCheckBox;
import team.creative.creativecore.common.gui.control.simple.GuiCheckButtonIcon;
import team.creative.creativecore.common.gui.control.simple.GuiColorPlate;
import team.creative.creativecore.common.gui.control.simple.GuiColoredSteppedSlider;
import team.creative.creativecore.common.gui.control.simple.GuiIcon;
import team.creative.creativecore.common.gui.control.simple.GuiLabel;
import team.creative.creativecore.common.gui.control.simple.GuiLabelHover;
import team.creative.creativecore.common.gui.control.simple.GuiListEntry;
import team.creative.creativecore.common.gui.control.simple.GuiProgressbar;
import team.creative.creativecore.common.gui.control.simple.GuiSeekBar;
import team.creative.creativecore.common.gui.control.simple.GuiShowItem;
import team.creative.creativecore.common.gui.control.simple.GuiSlider;
import team.creative.creativecore.common.gui.control.simple.GuiStateButton;
import team.creative.creativecore.common.gui.control.simple.GuiStateButtonIcon;
import team.creative.creativecore.common.gui.control.simple.GuiSteppedSlider;
import team.creative.creativecore.common.gui.control.simple.GuiTabButton;
import team.creative.creativecore.common.gui.control.simple.GuiTextfield;
import team.creative.creativecore.common.gui.control.timeline.GuiTimeline;
import team.creative.creativecore.common.gui.control.timeline.GuiTimelineChannel;
import team.creative.creativecore.common.gui.control.timeline.GuiTimelineHeader;
import team.creative.creativecore.common.gui.control.timeline.GuiTimelineKey;
import team.creative.creativecore.common.gui.control.tree.GuiTree;
import team.creative.creativecore.common.gui.control.tree.GuiTreeItem;
import team.creative.creativecore.common.gui.integration.ContainerIntegration;
import team.creative.creativecore.common.gui.manager.GuiManager;
import team.creative.creativecore.common.gui.manager.GuiManagerItem;
import team.creative.creativecore.common.util.type.list.Pair;
import team.creative.creativecore.common.util.type.list.PairList;

public class GuiClientRegistry {
    private static final PairList<Class<? extends GuiControl>, Function<GuiControl, GuiClientControl>> CONTROL_FACTORY = new PairList();
    private static final Object2ObjectMap<Class<? extends GuiControl>, Function<GuiControl, GuiClientControl>> BACKUP_CONTROL_FACTORY = new Object2ObjectArrayMap();
    private static final List<Function<GuiControl, GuiClientControl>> CONTROL_SPECIAL_FACTORY = new ArrayList<Function<GuiControl, GuiClientControl>>();
    private static final Object2ObjectMap<Class<? extends GuiManager>, Function<GuiManager, GuiClientManager>> MANAGER_FACTORY = new Object2ObjectArrayMap();

    public static GuiClientControl create(GuiControl control) {
        int i;
        Function function = CONTROL_FACTORY.getValue(control.getClass());
        if (function != null) {
            return function.apply((GuiControl)control);
        }
        for (i = 0; i < CONTROL_SPECIAL_FACTORY.size(); ++i) {
            GuiClientControl result = CONTROL_SPECIAL_FACTORY.get(i).apply(control);
            if (result == null) continue;
            return result;
        }
        function = (Function)BACKUP_CONTROL_FACTORY.get(control.getClass());
        if (function == null) {
            i = CONTROL_FACTORY.size();
            while (--i >= 0) {
                Pair pair = (Pair)CONTROL_FACTORY.get(i);
                if (!((Class)pair.key).isInstance(control)) continue;
                function = (Function)pair.value;
                BACKUP_CONTROL_FACTORY.put((Object)((Class)pair.key), (Object)function);
                break;
            }
            if (function == null) {
                throw new IllegalArgumentException("No dist handler found for control " + String.valueOf(control));
            }
        }
        return (GuiClientControl)function.apply(control);
    }

    public static GuiClientManager create(GuiManager manager) {
        Function function = (Function)MANAGER_FACTORY.get(manager.getClass());
        if (function != null) {
            return (GuiClientManager)function.apply(manager);
        }
        return null;
    }

    public static <T extends GuiControl> void register(Class<T> clazz, Function<T, GuiClientControl> factory) {
        CONTROL_FACTORY.add(clazz, factory);
    }

    public static <T extends GuiManager> void registerManager(Class<T> clazz, Function<T, GuiClientManager> factory) {
        MANAGER_FACTORY.put(clazz, factory);
    }

    public static void registerSpecial(Function<GuiControl, GuiClientControl> factory) {
        CONTROL_SPECIAL_FACTORY.add(factory);
    }

    static {
        GuiClientRegistry.register(GuiParent.class, GuiClientParent::new);
        GuiClientRegistry.register(GuiLayer.class, GuiClientLayer::new);
        GuiClientRegistry.register(GuiLabel.class, GuiClientLabel::new);
        GuiClientRegistry.register(GuiLabelHover.class, GuiClientLabelHover::new);
        GuiClientRegistry.register(GuiButton.class, GuiClientButton::new);
        GuiClientRegistry.register(GuiButtonHold.class, GuiClientButtonHold::new);
        GuiClientRegistry.register(GuiButtonContext.class, GuiClientButtonContext::new);
        GuiClientRegistry.register(GuiClientButtonContext.GuiButtonContextMenu.class, GuiClientButtonContext.GuiClientButtonContextMenu::new);
        GuiClientRegistry.register(GuiTextfield.class, GuiClientTextfield::new);
        GuiClientRegistry.register(GuiProgressbar.class, GuiClientProgressbar::new);
        GuiClientRegistry.register(GuiIcon.class, GuiClientIcon::new);
        GuiClientRegistry.register(GuiButtonIcon.class, GuiClientButtonIcon::new);
        GuiClientRegistry.register(GuiCheckButtonIcon.class, GuiClientCheckButtonIcon::new);
        GuiClientRegistry.register(GuiCheckBox.class, GuiClientCheckBox::new);
        GuiClientRegistry.register(GuiTabButton.class, GuiClientTabButton::new);
        GuiClientRegistry.register(GuiSlider.class, GuiClientSlider::new);
        GuiClientRegistry.register(GuiSteppedSlider.class, GuiClientSteppedSlider::new);
        GuiClientRegistry.register(GuiColoredSteppedSlider.class, GuiClientColoredSteppedSlider::new);
        GuiClientRegistry.register(GuiArraySlider.class, GuiClientArraySlider::new);
        GuiClientRegistry.register(GuiColorPlate.class, GuiClientColorPlate::new);
        GuiClientRegistry.register(GuiListEntry.class, GuiClientListEntry::new);
        GuiClientRegistry.register(GuiSeekBar.class, GuiClientSeekBar::new);
        GuiClientRegistry.register(GuiShowItem.class, GuiClientShowItem::new);
        GuiClientRegistry.register(GuiStateButton.class, GuiClientStateButton::new);
        GuiClientRegistry.register(GuiStateButtonIcon.class, GuiClientStateButtonIcon::new);
        GuiClientRegistry.register(GuiPanel.class, GuiClientPanel::new);
        GuiClientRegistry.register(GuiScrollX.class, GuiClientScrollX::new);
        GuiClientRegistry.register(GuiScrollXY.class, GuiClientScrollXY::new);
        GuiClientRegistry.register(GuiScrollY.class, GuiClientScrollY::new);
        GuiClientRegistry.register(GuiTable.class, GuiClientTable::new);
        GuiClientRegistry.register(GuiTableScrollable.class, GuiClientTableScrollable::new);
        GuiClientRegistry.register(GuiTabs.class, GuiClientTabs::new);
        GuiClientRegistry.register(GuiCheckList.class, GuiClientCheckList::new);
        GuiClientRegistry.register(GuiListBoxBase.class, GuiClientListBoxBase::new);
        GuiClientRegistry.register(GuiComboBox.class, GuiClientComboBox::new);
        GuiClientRegistry.register(GuiComboBoxExtension.class, GuiClientComboBoxExtension::new);
        GuiClientRegistry.register(GuiComboBoxFlexible.class, GuiClientComboBoxFlexible::new);
        GuiClientRegistry.register(GuiComboBoxTree.class, GuiClientComboBoxTree::new);
        GuiClientRegistry.register(GuiStackSelector.class, GuiClientStackSelector::new);
        GuiClientRegistry.register(GuiStackSelectorExtension.class, GuiClientStackSelectorExtension::new);
        GuiClientRegistry.register(GuiMenu.GuiMenuEntry.class, GuiClientMenu.GuiClientMenuEntry::new);
        GuiClientRegistry.register(GuiMenuRoot.class, GuiClientMenuRoot::new);
        GuiClientRegistry.register(GuiMenuSub.class, GuiClientMenuSub::new);
        GuiClientRegistry.register(GuiInventoryGrid.class, GuiClientInventoryGrid::new);
        GuiClientRegistry.register(GuiInventoryGridPreview.class, GuiClientInventoryGridPreview::new);
        GuiClientRegistry.register(GuiSlotViewer.class, GuiClientSlotViewer::new);
        GuiClientRegistry.register(GuiSlot.class, GuiClientSlot::new);
        GuiClientRegistry.register(GuiTimelineKey.class, GuiClientTimelineKey::new);
        GuiClientRegistry.register(GuiTimelineChannel.class, GuiClientTimelineChannel::new);
        GuiClientRegistry.register(GuiTimelineHeader.class, GuiClientTimelineHeader::new);
        GuiClientRegistry.register(GuiTimeline.class, GuiClientTimeline::new);
        GuiClientRegistry.register(GuiTree.class, GuiClientTree::new);
        GuiClientRegistry.register(GuiTreeItem.class, GuiClientTreeItem::new);
        GuiClientRegistry.register(ClientSyncGuiLayer.GuiTreeCheckBox.class, GuiClientTreeCheckBox::new);
        GuiClientRegistry.registerManager(GuiManagerItem.class, GuiClientManagerItem::new);
        ContainerIntegration.EMPTY_CLIENT = new GuiLayer(true, "empty"){

            @Override
            public void create() {
            }
        };
    }
}

