/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.gui.control.timeline;

import net.minecraft.class_11910;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import org.joml.Matrix3x2fStack;
import team.creative.creativecore.client.gui.GuiClientParent;
import team.creative.creativecore.client.gui.control.timeline.GuiClientTimeline;
import team.creative.creativecore.client.render.gui.CreativeGuiGraphics;
import team.creative.creativecore.common.gui.control.timeline.GuiAnimationHandler;
import team.creative.creativecore.common.gui.control.timeline.GuiTimelineHeader;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.gui.style.GuiStyle;
import team.creative.creativecore.common.gui.style.display.StyleDisplay;

public class GuiClientTimelineHeader<T extends GuiTimelineHeader>
extends GuiClientParent<T> {
    public boolean dragged = false;

    public GuiClientTimelineHeader(T control) {
        super(control);
    }

    public GuiClientTimeline timeline() {
        return (GuiClientTimeline)((GuiTimelineHeader)this.control).timeline.dist();
    }

    public GuiAnimationHandler handler() {
        return ((GuiTimelineHeader)this.control).timeline.handler;
    }

    @Override
    public boolean mouseClicked(double x, double y, class_11910 info) {
        this.dragged = true;
        this.handler().set(this.timeline().getTimeAt(x));
        this.playSound(class_3417.field_29192);
        return true;
    }

    @Override
    public void mouseMoved(double x, double y) {
        int tick;
        if (this.dragged && (tick = this.timeline().getTimeAt(x)) != this.handler().get()) {
            this.handler().set(tick);
            this.playSound(class_3417.field_29192, 0.02f, 1.0f);
        }
    }

    @Override
    public void mouseReleased(double x, double y, class_11910 info) {
        this.dragged = false;
    }

    @Override
    public boolean mouseScrolled(double x, double y, double delta) {
        this.timeline().scrolled(this.rect.getWidth(), x, delta);
        return true;
    }

    @Override
    protected void renderContent(class_332 graphics, int mouseX, int mouseY) {
        if (this.timeline().getLastZoom() != this.timeline().zoom.current()) {
            this.timeline().setLastZoom(this.timeline().zoom.current());
            this.timeline().adjustKeysPositionX();
        }
        Matrix3x2fStack pose = graphics.method_51448();
        double tickWidth = this.timeline().getTickWidth();
        int width = this.rect.getContentWidth();
        int height = this.rect.getContentHeight();
        int contentOffset = this.getContentOffset() - 1;
        pose.translate((float)(this.timeline().timelineOffset - 1), (float)(-contentOffset));
        int ticks = (int)((double)width / tickWidth);
        int area = 5;
        int halfArea = 5;
        int smallestStep = 0;
        while (Math.pow(area, smallestStep) * tickWidth < 3.0) {
            ++smallestStep;
        }
        smallestStep = (int)Math.pow(area, smallestStep);
        double stepWidth = tickWidth * (double)smallestStep;
        int stepOffset = (int)(this.timeline().scrollX.current() / stepWidth);
        int stamps = ticks / smallestStep;
        int begin = Math.max(0, stepOffset);
        int end = stepOffset + stamps + 1;
        int pointerWidth = Math.max((int)tickWidth, 1);
        GuiClientTimeline.CURSOR_HIGHLIGHT.render(graphics, tickWidth * (double)this.handler().get() - (double)pointerWidth / 2.0 - this.timeline().scrollX.current(), 0.0, pointerWidth, height);
        GuiStyle style = this.getStyle();
        StyleDisplay border = style.get(ControlFormatting.ControlStyleBorder.SMALL);
        class_327 font = ((CreativeGuiGraphics)graphics).font();
        pose.pushMatrix();
        pose.translate((float)(-this.timeline().scrollX.current() + (double)begin * stepWidth), 0.0f);
        for (int i = begin; i < end; ++i) {
            if (i % halfArea == 0) {
                border.render(graphics, 1.0, 4.0);
                String text = "" + i * smallestStep;
                graphics.method_51433(class_310.method_1551().field_1772, text, 0 - font.method_1727(text) / 2, 5, -16777216, false);
            } else {
                border.render(graphics, 1.0, 2.0);
            }
            pose.translate((float)stepWidth, 0.0f);
        }
        pose.popMatrix();
    }

    @Override
    public void flowX(int width, int preferred) {
        super.flowX(width, preferred);
        this.timeline().resized(width);
    }
}

