/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fastitemframes.client.renderer.blockentity;

import fuzs.fastitemframes.client.handler.ClientEventHandler;
import fuzs.fastitemframes.client.renderer.blockentity.state.ItemFrameBlockRenderState;
import fuzs.fastitemframes.init.ModRegistry;
import fuzs.fastitemframes.world.level.block.ItemFrameBlock;
import fuzs.fastitemframes.world.level.block.entity.ItemFrameBlockEntity;
import fuzs.puzzleslib.api.client.renderer.v1.RenderStateExtraData;
import net.minecraft.class_10017;
import net.minecraft.class_10040;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1297;
import net.minecraft.class_1533;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_5614;
import net.minecraft.class_827;
import net.minecraft.class_897;
import net.minecraft.class_898;
import net.minecraft.class_9064;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class ItemFrameBlockRenderer
implements class_827<ItemFrameBlockEntity, ItemFrameBlockRenderState> {
    private final class_898 entityRenderDispatcher;

    public ItemFrameBlockRenderer(class_5614.class_5615 context) {
        this.entityRenderDispatcher = context.comp_4538();
    }

    public static class_2680 getItemFrameBlockState(boolean isGlowFrame, boolean isMapFrame, boolean isDyed) {
        class_2248 block = ItemFrameBlockRenderer.getItemFrameBlock(isGlowFrame);
        return (class_2680)((class_2680)block.method_9564().method_11657((class_2769)ItemFrameBlock.MAP, (Comparable)Boolean.valueOf(isMapFrame))).method_11657((class_2769)ItemFrameBlock.DYED, (Comparable)Boolean.valueOf(isDyed));
    }

    private static class_2248 getItemFrameBlock(boolean isGlowFrame) {
        return isGlowFrame ? (class_2248)ModRegistry.GLOW_ITEM_FRAME_BLOCK.comp_349() : (class_2248)ModRegistry.ITEM_FRAME_BLOCK.comp_349();
    }

    public ItemFrameBlockRenderState createRenderState() {
        return new ItemFrameBlockRenderState();
    }

    public void extractRenderState(ItemFrameBlockEntity blockEntity, ItemFrameBlockRenderState renderState, float partialTick, class_243 cameraPosition, @Nullable class_11683.class_11792 crumblingOverlay) {
        super.method_74331((class_2586)blockEntity, (class_11954)renderState, partialTick, cameraPosition, crumblingOverlay);
        class_1533 itemFrame = blockEntity.getEntityRepresentation();
        if (itemFrame != null) {
            class_897 entityRenderer = this.entityRenderDispatcher.method_3953((class_1297)itemFrame);
            renderState.isInvisible = blockEntity.isInvisible();
            renderState.entityRenderState = (class_10040)entityRenderer.method_62425((class_1297)itemFrame, partialTick);
            RenderStateExtraData.remove((class_10017)renderState.entityRenderState, ClientEventHandler.COLOR_RENDER_PROPERTY_KEY);
            renderState.entityRenderState.field_53333 = true;
            if (this.shouldShowName(blockEntity, itemFrame, cameraPosition)) {
                renderState.entityRenderState.field_53337 = entityRenderer.method_62426((class_1297)itemFrame);
                renderState.entityRenderState.field_53338 = itemFrame.method_56072().method_55675(class_9064.field_47745, 0, itemFrame.method_61415(partialTick));
            } else {
                renderState.entityRenderState.field_53337 = null;
            }
        }
    }

    protected boolean shouldShowName(ItemFrameBlockEntity blockEntity, class_1533 itemFrame, class_243 cameraPosition) {
        class_239 hitResult;
        if (class_310.method_1498() && !itemFrame.method_6940().method_7960() && itemFrame.method_6940().method_57826(class_9334.field_49631) && (hitResult = class_310.method_1551().field_1765) != null && hitResult.method_17783() == class_239.class_240.field_1332 && blockEntity.method_11016().equals((Object)((class_3965)hitResult).method_17777())) {
            double distanceToEntity = cameraPosition.method_1025(itemFrame.method_73189());
            double permittedDistance = itemFrame.method_21751() ? 32.0 : 64.0;
            return distanceToEntity < permittedDistance * permittedDistance;
        }
        return false;
    }

    public void submit(ItemFrameBlockRenderState renderState, class_4587 poseStack, class_11659 submitNodeCollector, class_12075 cameraRenderState) {
        if (!renderState.entityRenderState.field_55314.method_65606()) {
            poseStack.method_22903();
            poseStack.method_46416(0.5f, 0.25f, 0.5f);
            class_2350 direction = renderState.entityRenderState.field_53438;
            poseStack.method_46416((float)direction.method_10148() * -0.1675f, (float)direction.method_10164() * -0.46875f, (float)direction.method_10165() * -0.1675f);
            if (!renderState.isInvisible) {
                poseStack.method_46416((float)direction.method_10148() * 0.0625f, (float)direction.method_10164() * 0.0625f, (float)direction.method_10165() * 0.0625f);
            }
            class_897 entityRenderer = this.entityRenderDispatcher.method_68832((class_10017)renderState.entityRenderState);
            entityRenderer.method_3936((class_10017)renderState.entityRenderState, poseStack, submitNodeCollector, cameraRenderState);
            poseStack.method_22909();
        }
    }

    public boolean shouldRender(ItemFrameBlockEntity blockEntity, class_243 cameraPos) {
        class_1533 itemFrame = blockEntity.getEntityRepresentation();
        if (itemFrame != null) {
            return itemFrame.method_5727(cameraPos.method_10216(), cameraPos.method_10214(), cameraPos.method_10215());
        }
        return super.method_33892((class_2586)blockEntity, cameraPos);
    }
}

