/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.slp;

import java.lang.reflect.Constructor;
import net.fabricmc.loader.api.LanguageAdapter;
import net.fabricmc.loader.api.LanguageAdapterException;
import net.fabricmc.loader.api.ModContainer;

public final class ScalaLanguageAdapter
implements LanguageAdapter {
    public <T> T create(ModContainer mod, String value, Class<T> type) throws LanguageAdapterException {
        Class<?> clazz;
        if (value.endsWith("$")) {
            try {
                Object obj = ScalaLanguageAdapter.getScalaObject(mod, value);
                return type.cast(obj);
            }
            catch (ClassCastException | ReflectiveOperationException e) {
                throw new LanguageAdapterException(String.format("Error in getting scala object of %s from %s", type, value), (Throwable)e);
            }
        }
        try {
            clazz = Class.forName(value + "$", false, ScalaLanguageAdapter.class.getClassLoader());
            Object obj = ScalaLanguageAdapter.getScalaObject(mod, value + "$");
            if (type.isInstance(obj)) {
                return type.cast(obj);
            }
        }
        catch (ClassCastException | ReflectiveOperationException clazz2) {
            // empty catch block
        }
        try {
            clazz = Class.forName(value, true, ScalaLanguageAdapter.class.getClassLoader());
            Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
            Object clsObject = constructor.newInstance(new Object[0]);
            return type.cast(clsObject);
        }
        catch (ClassCastException | ReflectiveOperationException e) {
            throw new LanguageAdapterException(String.format("Error in constructing an instance of %s from %s", type, value), (Throwable)e);
        }
    }

    private static Object getScalaObject(ModContainer mod, String value) throws ReflectiveOperationException, ClassCastException {
        Class<?> clazz = Class.forName(value, true, ScalaLanguageAdapter.class.getClassLoader());
        return clazz.getField("MODULE$").get(null);
    }
}

